package com.yiboshi.science.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 登录日志表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "登录日志表VO")
public class LogsLogin extends BaseEntity {

    /** id */
    @ApiModelProperty(value = "id" )
    @Length(max=36, message = "id不能大于36")
    @TableId(value="id",type = IdType.UUID )
    private String id;
    /** 用户Id */
    @ApiModelProperty(value = "用户名" )
    @Length(max=36, message = "用户名大于100")
    private String username;
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4)
    private String personId;
    /** 登录名 */
    @ApiModelProperty(value = "登录名" )
    private String loginName;
    /** 登录单位 */
    @ApiModelProperty(value = "登录单位" )
    private String loginUnit;
    /** 角色*/
    @ApiModelProperty(value = "角色", position = 7 )
    private String roles;
    /** 登录ip */
    @ApiModelProperty(value = "登录ip", position = 3 )
    @Length(max=50, message = "登录ip不能大于50")
    private String loginIp;
    /** 参数 */
    @ApiModelProperty(value = "参数", position = 3)
    private String logParam;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4 )
    @Length(max=100, message = "备注不能大于100")
    private String remark;
}