package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目组分配表VO")
public class ComProjectGroupAssign extends BaseEntity {

    /** 项目组Id */
    @ApiModelProperty(value = "项目组Id", position = 1)
    @Length(max=36, message = "项目组Id不能大于36")
    private String groupId;

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 2)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;
}
