package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 经费申请表（任务书/项目申请书）VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "经费申请表（任务书/项目申请书）VO")
public class ComProjectFundComposition extends BaseEntity {
    /** 对象id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象id（项目Id/任务书Id）", position = 2 )
    @Length(max=36, message = "对象id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 2 )
    private Integer year;
    /** 总  额 */
    @ApiModelProperty(value = "总  额", position = 3 )
    private BigDecimal totalFund;
    /** 自治区公立医院专项资金 */
    @ApiModelProperty(value = "自治区公立医院专项资金", position = 3 )
    private BigDecimal specialFund;
    /** 自筹经费 */
    @ApiModelProperty(value = "自筹经费", position = 3 )
    private BigDecimal selfFund;
    /** 盟市财政资金 */
    @ApiModelProperty(value = "盟市财政资金", position = 3 )
    private BigDecimal cityFund;
    /** 其他渠道资金 */
    @ApiModelProperty(value = "其他渠道资金", position = 3 )
    private BigDecimal otherFund;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 6 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;
}