package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 合作单位表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "合作单位表VO")
public class ComProjectCooperativeUnits extends BaseEntity {

    /** 对象Id（项目Id/任务书Id） */
    @ApiModelProperty(value = "对象Id（项目Id/任务书Id）", position = 1 )
    @Length(max=36, message = "对象Id（项目Id/任务书Id）不能大于36")
    private String objectId;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 2 )
    @Length(max=200, message = "单位名称不能大于200")
    private String unitName;
    /** 单位国别 */
    @ApiModelProperty(value = "单位国别", position = 2 )
    @Length(max=200, message = "单位国别不能大于200")
    private String unitCountry;
    /** 单位地址 */
    @ApiModelProperty(value = "单位地址", position = 3 )
    @Length(max=200, message = "单位地址不能大于200")
    private String unitAddress;
    /** 组织机构代码/统社会信用代码 */
    @ApiModelProperty(value = "组织机构代码/统社会信用代码", position = 2 )
    @Length(max=100, message = "组织机构代码/统社会信用代码不能大于100")
    private String organizationCode;
    /** 在项目中的分工 */
    @ApiModelProperty(value = "在项目中的分工", position = 4 )
    @Length(max=300, message = "在项目中的分工不能大于300")
    private String projectWork;
    /** 类型 */
    @ApiModelProperty(value = "类型", position = 10 )
    private Integer type;
    /** 排序 */
    @ApiModelProperty(value = "排序", position = 10 )
    private Integer showIndex;

}