package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComTalentGroup;
import com.yiboshi.science.param.dto.*;
import com.yiboshi.science.param.query.ComTalentGroupQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人才分组表
 */
public interface ComTalentGroupDAO extends BaseMapper<ComTalentGroup>, BaseDAO<ComTalentGroupQueryVO, ComTalentGroupDTO, ComTalentGroup> {

    ComTalentGroupDTO getTalentGroupByKnowLedgeIDYear(@Param("groupYear") Integer name);

    List<ComTalentAssignDTO> getAssignExpertList(String talentId);

    List<ComTalentKnowledgeStatisticDTO> getTalentKnowledgeStatisticByGroupId(String groupId);
}
