package com.yiboshi.science.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * /**
 * class: 下换线/驼峰命名转换$
 * create by: wxl$
 * description:
 * create time: $
 *
 * @param: $
 */
public class StringUtil {

    /**
     * 下划线命名转驼峰命名
     *
     * @param underscore
     * @return
     */
    public static String underscoreToCamelCase(String underscore) {
        String[] ss = underscore.split("_");
        if (ss.length == 1) {
            return underscore;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; i++) {
            sb.append(upperFirstCase(ss[i]));
        }

        return sb.toString();
    }

    /**
     * 驼峰 转下划线
     *
     * @param camelCase
     * @return
     */
    public static String toLine(String camelCase) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(camelCase);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 首字母 转小写
     *
     * @param str
     * @return
     */
    private static String lowerFirstCase(String str) {
        char[] chars = str.toCharArray();
        chars[0] += 32;
        return String.valueOf(chars);
    }

    /**
     * 首字母 转大写
     *
     * @param str
     * @return
     */
    private static String upperFirstCase(String str) {
        char[] chars = str.toCharArray();
        chars[0] -= 32;
        return String.valueOf(chars);
    }

    public static void main(String[] args) {
        String camelCase = StringUtil.underscoreToCamelCase("cteate_time");
        System.out.println(camelCase);//cteateTime
        System.out.println(toLine("cteateTimeAndUser"));//cteate_time_and_user
    }

    public static boolean arrEquals(String[] arr, Integer targetValue) {
        for (String s : arr) {
            if (s.equals(targetValue.toString()))
                return true;
        }
        return false;
    }

    public static boolean isContainsRole(String roleArr, String Role) {
        String[] arr = roleArr.split(",");
        int a = Arrays.binarySearch(arr, Role);
        if (a >= 0) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param t1 用于赋值的实体类
     * @param t2 需要待赋值的实体类
     */
    public static Object copyObj2Obj(Object t1, Object t2) {
        Class ct1 = (Class) t1.getClass();
        Class ct2 = (Class) t2.getClass();
        Field[] fs = ct1.getDeclaredFields();
        Field[] nfs = ct2.getDeclaredFields();
        for (int i = 0; i < fs.length; i++) {
            Field f = fs[i];
            f.setAccessible(true); //设置些属性是可以访问的
            Object val = new Object();
            try {
                val = f.get(t1);//得到此属性的值
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            for (int j = 0; j < nfs.length; j++) {
                Field nf = nfs[j];
                nf.setAccessible(true); //设置些属性是可以访问的
                if (f.getName().equals(nf.getName())) {
                    try {
                        nf.set(t2, val);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return t2;
    }

    /**
     * 隐藏手机号
     *
     * @param phoneNum
     * @return
     */
    public static String hideAllPhoneNum(String phoneNum) {
        if (phoneNum != null && !phoneNum.equals("")) {
            Pattern pattern = Pattern.compile("((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}");
            Matcher matcher = pattern.matcher(phoneNum);
            StringBuffer sb = new StringBuffer();
            try {
                while (matcher.find()) {
                    String phoneStr = matcher.group();
                    phoneStr = phoneStr.substring(0, 3) + "****" + phoneStr.substring(7, phoneStr.length());
                    matcher.appendReplacement(sb, phoneStr);
                }
                matcher.appendTail(sb);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            return sb.toString();
        } else return null;
    }

    /**
     * 隐藏身份证号码
     *
     * @param idCardNum
     * @return
     */
    public static String hideAllIdCardNum(String idCardNum) {
        if (idCardNum != null && !idCardNum.equals("")) {
            Pattern pattern = Pattern.compile("(\\d{6})(19|20)(\\d{2})(1[0-2]|0[1-9])(0[1-9]|[1-2][0-9]|3[0-1])(\\d{3})(\\d|X|x)");
            Matcher matcher = pattern.matcher(idCardNum);
            StringBuffer sb = new StringBuffer();
            try {
                while (matcher.find()) {
                    String idCardStr = matcher.group();
                    int len = idCardStr.length();
                    if (len >= 9) {
                        idCardStr = idCardStr.replaceAll("(.{" + (len < 12 ? 3 : 8) + "})(.*)(.{2})", "$1" + "********" + "$3");
                    }
                    matcher.appendReplacement(sb, idCardStr);
                }
                matcher.appendTail(sb);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            return sb.toString();
        } else return null;
    }
}

