package com.yiboshi.science.utils;

import java.math.BigInteger;

/**
 * 128进制加解密, 一个符号可表示7个bit
 * 可以自定义符号表, 符号不能重复
 * @author lry
 *
 */
public class ConversionUtil {

    private static char[] depository = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    //数字转62进制
    public static String encode(String str) {
        BigInteger num = new BigInteger(str);
        BigInteger bint62 = new BigInteger(String.valueOf(62));
        StringBuffer stringBuffer = new StringBuffer();

        while (true) {
            BigInteger remainder = num.mod(bint62);
            stringBuffer.append(depository[remainder.intValue()]);
            num = num.divide(bint62);
            if (num.intValue() == 0) break;
        }
        //将字符串进行翻转
        stringBuffer.reverse();
        return stringBuffer.toString();

    }

    //62进制转为数字
    public static String decode(String num) {
        String[] depository = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        //输入的数据
        BigInteger data = new BigInteger(String.valueOf(0));

        String result[] = new String[62];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(num);
        StringBuffer reverse = stringBuffer.reverse();
        BigInteger bint62 = new BigInteger(String.valueOf(62));
        for (int i = 0; i < reverse.length(); i++) {
            String substr = reverse.substring(i, i + 1);
            result[i] = substr;

            for (int j = 0; j < depository.length; j++) {
                if ((result[i]).equals(depository[j])) {
                    data = (data.add(bint62.pow(i).multiply(new BigInteger(String.valueOf(j)))));
                    continue;
                }
            }
        }
        return data.toString();
    }
}
