package com.yiboshi.science.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.SystemParameterTypeDAO;
import com.yiboshi.science.entity.SystemParameterType;
import com.yiboshi.science.param.dto.SystemParameterTypeDTO;
import com.yiboshi.science.param.query.SystemParameterTypeQueryVO;
import com.yiboshi.science.service.SystemParameterTypeService;
import com.yiboshi.science.utils.RedisKey;
import com.yiboshi.science.utils.RedisUtils;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 参数类型表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
@AllArgsConstructor
public class SystemParameterTypeServiceImpl extends BaseServiceImpl<SystemParameterTypeDAO, SystemParameterTypeQueryVO, SystemParameterTypeDTO, SystemParameterType> implements SystemParameterTypeService {

    private final RedisUtils redisUtils;

    @Autowired
    private SystemParameterTypeDAO systemParameterTypeDAO;


    @Override
    protected void setCriteriaForQuery(SystemParameterTypeQueryVO vo, QueryWrapper<SystemParameterTypeQueryVO> criteria) {
        if (Objects.nonNull(vo.getTypeId())) {
            criteria.eq("type_id", vo.getTypeId());
        }
        if (Objects.nonNull(vo.getParentId())) {
            criteria.eq("parent_id", vo.getParentId());
        }
        if (Objects.nonNull(vo.getName())) {
            criteria.eq("name", vo.getName());
        }
        if (Objects.nonNull(vo.getGbCode())) {
            criteria.eq("gb_code", vo.getGbCode());
        }
        if (Objects.nonNull(vo.getDisplayOrder())) {
            criteria.eq("display_order", vo.getDisplayOrder());
        }
        if (Objects.nonNull(vo.getSystemCode())) {
            criteria.eq("system_code", vo.getSystemCode());
        }
    }

    @Override
    public Pagination<SystemParameterTypeDTO> getListByPage(SystemParameterTypeQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<SystemParameterTypeQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<SystemParameterTypeDTO> dtoList = systemParameterTypeDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public List<SystemParameterType> getParameterTypeList() {
        return this.getList();
    }

    public String save(SystemParameterTypeDTO dto) {
        if (null == dto.getId()) {
            return insertSystemParameterType(dto);
        } else {
            return updateSystemParameterType(dto);
        }
    }

    public String insertSystemParameterType(SystemParameterTypeDTO dto) {
        SystemParameterType parameterType = this.convert2Entity(dto);
        Integer roleId = getMaxTypeId();
        parameterType.setTypeId(roleId == null ? 1 : roleId + 1);
        String id = this.insert(parameterType);
        refreshSystemParameterType();
        return id;
    }

    public String updateSystemParameterType(SystemParameterTypeDTO dto) {
        SystemParameterType parameterType = this.entityById(dto.getId());
        if (null == parameterType)
            throw new BusinessException("系统参数不存在或已删除!");
        String id = this.update(this.convert2Entity(dto));
        refreshSystemParameterType();
        return id;
    }

    @Override
    public Integer getMaxTypeId() {
        return systemParameterTypeDAO.getMaxTypeId();
    }

    public SystemParameterType getParameterTypeByType(Integer typeId) {
        List<SystemParameterType> list = getList();
        if (null == list)
            return null;
        SystemParameterType systemParameter = list.stream().filter(e -> e.getTypeId().equals(typeId)).findFirst().get();
        return systemParameter;
    }

    public List<SystemParameterType> getParameterTypeList(String name) {
        List<SystemParameterType> list = getList();
        if (null == list)
            return null;
        return list.stream().filter(e -> e.getName().contains(name)).collect(Collectors.toList());
    }

    public String deleteParameterTypeById(String id) {
        SystemParameterType parameter = this.entityById(id);
        if (null == parameter)
            throw new BusinessException("参数不存在或已删除!");
        this.deleteById(id);
        refreshSystemParameterType();
        return "ok";
    }

    public List<SystemParameterType> getList() {
        List<SystemParameterType> list = null;
        Object obj = redisUtils.get(RedisKey.ParameterTypeList);
        if (null != obj)
            list = (List<SystemParameterType>) redisUtils.get(RedisKey.ParameterTypeList);
        else {
            list = systemParameterTypeDAO.getList(new QueryWrapper());
            redisUtils.set(RedisKey.ParameterTypeList, list, 7, TimeUnit.DAYS);
        }
        return list;
    }

    public void refreshSystemParameterType() {
        if (redisUtils.hasKey(RedisKey.ParameterTypeList))
            redisUtils.del(RedisKey.ParameterTypeList);
        this.getList();
    }
}
