package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.LogsLoginDAO;
import com.yiboshi.science.entity.LogsLogin;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.dto.LogsLoginDTO;
import com.yiboshi.science.param.query.LogsLoginQueryVO;
import com.yiboshi.science.service.LogsLoginService;
import com.yiboshi.science.utils.CustomerIPAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

/**
 * 登录日志表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class LogsLoginServiceImpl extends BaseServiceImpl<LogsLoginDAO, LogsLoginQueryVO, LogsLoginDTO, LogsLogin> implements LogsLoginService {

    @Autowired
    private LogsLoginDAO logsLoginDAO;

    @Autowired
    protected HttpServletRequest request;

    @Override
    protected void setCriteriaForQuery(LogsLoginQueryVO vo, QueryWrapper<LogsLoginQueryVO> criteria) {
        if(Objects.nonNull(vo.getUsername())){
            criteria.eq("username", vo.getUsername());
        }
        if(Objects.nonNull(vo.getLoginName())){
            criteria.eq("login_name", vo.getLoginName());
        }
        if(Objects.nonNull(vo.getLoginUnit())){
            criteria.eq("login_unit", vo.getLoginUnit());
        }
        if(Objects.nonNull(vo.getLoginIp())){
            criteria.eq("login_ip", vo.getLoginIp());
        }
        if(Objects.nonNull(vo.getRemark())){
            criteria.like("remark", vo.getRemark());
        }
    }

    @Override
    public Pagination<LogsLoginDTO> getListByPage(LogsLoginQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<LogsLoginQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<LogsLoginDTO> dtoList = logsLoginDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    public void log(String loginName,String username, String personId, String roles, String param,String loginUnit,String unitName){
        LogsLogin log = new LogsLogin();
        log.setUsername(username);
        log.setPersonId(personId);
        log.setRoles(roles);
        log.setLogParam(param);
        log.setLoginName(loginName);
        log.setLoginUnit(loginUnit);
        log.setRemark(unitName);
        log.setLoginIp(CustomerIPAddress.getIPAddress(request));
        this.insert(log);
    }

    public  DataStatisticsDTO getCount(){
        return logsLoginDAO.getCount();
    }

    public  DataStatisticsDTO getCountByDay(){
        return logsLoginDAO.getCountByDay();
    }
}
