package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectResearch;
import com.yiboshi.science.param.dto.ComProjectResearchDTO;
import com.yiboshi.science.param.query.ComProjectResearchQueryVO;

import java.util.List;

/**
 * 项目申请书在研项目情况表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectResearchService extends BaseService<ComProjectResearchQueryVO, ComProjectResearchDTO,ComProjectResearch> {
    /** 获取列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectResearchDTO> getListByObjectId(String objectId);

    /** 插入列表
     *
     * @param fileList
     * @param objectId
     */
    void insertList(List<ComProjectResearchDTO> fileList, String objectId);
    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
