package com.yiboshi.science.service;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectMembers;
import com.yiboshi.science.param.dto.ComProjectMembersDTO;
import com.yiboshi.science.param.query.ComProjectMembersQueryVO;

import java.util.List;

/**
 * 项目组成员表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectMembersService extends BaseService<ComProjectMembersQueryVO, ComProjectMembersDTO,ComProjectMembers> {
    /** 根据对象获取项目组成员列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectMembersDTO> getListByObjectId(String objectId);


    /**插入项目组成员
     *
     * @param list
     * @param objectId
     */
    void insertList(List<ComProjectMembersDTO> list, String objectId);

    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);

    /**获取统计数
     *
     * @param objectId
     * @param objectId
     */
    ComProjectMembersDTO getMemCountById(String objectId);
}
