package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.LogsRequestException;
import com.yiboshi.science.param.dto.LogsRequestExceptionDTO;
import com.yiboshi.science.param.query.LogsRequestExceptionQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.LogsRequestExceptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 功能：请求异常日志表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "logs-request-exception",description = "请求异常日志表")
@RestController
@RequestMapping("/v1/science-admin/logs-request-exception")
public class LogsRequestExceptionController extends BaseController<LogsRequestExceptionService, LogsRequestExceptionQueryVO, LogsRequestExceptionDTO, LogsRequestException> {

    @Autowired
    private LogsRequestExceptionService logsRequestExceptionService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<LogsRequestExceptionDTO>> getListByPage(@Validated LogsRequestExceptionQueryVO vo, BindingResult bindingResult) {
        Pagination<LogsRequestExceptionDTO> page = logsRequestExceptionService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }
}
