package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "DTO")
public class ProjectImportDTO extends BaseDTO {
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    @Length(max=50, message = "项目名称不能大于50")
    private String projName;
    /** 项目名称(英文) */
    @ApiModelProperty(value = "项目名称(英文)", position = 1 )
    @Length(max=200, message = "项目名称(英文)不能大于200")
    private String englishName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    @Length(max=100, message = "项目编号不能大于100")
    private String projNo;
    /** 主题词 */
    @ApiModelProperty(value = "主题词", position = 26 )
    @Length(max=200, message = "主题词不能大于200")
    private String projKeywords;
    /** 主题词(英文) */
    @ApiModelProperty(value = "主题词(英文)", position = 26 )
    @Length(max=200, message = "主题词(英文)不能大于200")
    private String keywordsEnglish;
    /** 主要研究内容和意义 */
    @ApiModelProperty(value = "主要研究内容和意义", position = 13 )
    @Length(max=1000, message = "主要研究内容和意义不能大于1000")
    private String projContent;
    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 申请金额 */
    @ApiModelProperty(value = "申请金额", position = 12 )
    private BigDecimal applyMoney;
    /** 学科 */
    @ApiModelProperty(value = "学科", position = 16)
    private String knowledgeName;
    /** 预期成果形式 */
    @ApiModelProperty(value = "预期成果形式", position = 8)
    private String anticipatedName;
    /** 项目状态 */
    @ApiModelProperty(value = "项目状态", position = 41)
    private String projStateName;

    /** 申报单位名称 */
    @ApiModelProperty(value = "单位名称", position = 41)
    private String appUnitName;
    /** 单位编码 */
    @ApiModelProperty(value = "单位编码", position = 22)
    private String unitCode;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 6)
    private String personName;
    /** 人员编码 */
    @ApiModelProperty(value = "人员编码", position = 22)
    private String personCode;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;

    /** 申报单位地址 */
    @ExcelProperty("申报单位地址")
    @ApiModelProperty(value = "申报单位地址", position = 6)
    private String appUnitAddress;
    /** 座机 */
    @ApiModelProperty(value = "座机", position = 16)
    private String telephone;

    /** 创建时间 */
    @ApiModelProperty(value = "创建时间", position = 7 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date created;

    /** 职称 */
    @ExcelProperty("职称")
    @ApiModelProperty(value = "职称", position = 10)
    private String titleName;

    /** 导入状态 */
    @ApiModelProperty(value = "导入状态", position = 22)
    private String importState;

    /** 备注 */
    private String remark;
}
