package com.yiboshi.science.param.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家项目分配表DTO")
public class ComProjectAssignDTO extends BaseDTO {
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 专家类型（1技术专家、2财务专家） */
    @ApiModelProperty(value = "专家类型", position = 3)
    private Integer expertType;
    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 3)
    private Integer assignYear;
    @ApiModelProperty(value = "score1", position = 4)
    private BigDecimal score1;
    @ApiModelProperty(value = "score2", position = 4)
    private BigDecimal score2;
    @ApiModelProperty(value = "score3", position = 4)
    private BigDecimal score3;
    @ApiModelProperty(value = "score4", position = 4)
    private BigDecimal score4;
    @ApiModelProperty(value = "score5", position = 4)
    private BigDecimal score5;
    @ApiModelProperty(value = "score6", position = 4)
    private BigDecimal score6;
    @ApiModelProperty(value = "score7", position = 4)
    private BigDecimal score7;
    @ApiModelProperty(value = "score8", position = 4)
    private BigDecimal score8;
    @ApiModelProperty(value = "score9", position = 4)
    private BigDecimal score9;
    @ApiModelProperty(value = "score10", position = 4)
    private BigDecimal score10;
    @ApiModelProperty(value = "score11", position = 4)
    private BigDecimal score11;
    @ApiModelProperty(value = "score12", position = 4)
    private BigDecimal score12;
    @ApiModelProperty(value = "score13", position = 4)
    private BigDecimal score13;
    @ApiModelProperty(value = "score14", position = 4)
    private BigDecimal score14;
    @ApiModelProperty(value = "score15", position = 4)
    private BigDecimal score15;
    @ApiModelProperty(value = "score16", position = 4)
    private BigDecimal score16;
    @ApiModelProperty(value = "score17", position = 4)
    private BigDecimal score17;
    @ApiModelProperty(value = "score18", position = 4)
    private BigDecimal score18;
    @ApiModelProperty(value = "score19", position = 4)
    private BigDecimal score19;
    /** 附加项 */
    @ApiModelProperty(value = "附加项", position = 9)
    private BigDecimal additionalScore;
    /** 申请经费 */
    @ApiModelProperty(value = "申请经费", position = 9)
    private BigDecimal applyFunding;
    /** 建议财政支持经费 */
    @ApiModelProperty(value = "建议财政支持经费", position = 9)
    private BigDecimal recommendFunding;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 9)
    private BigDecimal totalScore;
    /** 备注 */
    @ApiModelProperty(value = "备注", position =10)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;
    /** 审核状态（0 未评审 1 保存 2 已提交） */
    @ApiModelProperty(value = "审核状态（0 未评审 1 已评审）", position = 11)
    private Integer auditState;
    /** 是否支持立项（0 不支持 1 支持） */
    @ApiModelProperty(value = "审核状态（0 不支持 1 支持）", position = 11)
    private Integer supportState;
    /** 不推荐原因 */
    @ApiModelProperty(value = "不推荐原因", position = 11)
    private String noSupportReason;
    /** 评审类别（A通过(80分及以上)、B返回修改(60分及以上)、C不通过(60分以下)） */
    @ApiModelProperty(value = "评审类别", position = 11)
    private Integer evaluationType;
    /** 是否展示（0 不展示 1 展示） */
    @ApiModelProperty(value = "是否展示（0 不展示 1 展示）", position = 11)
    private Integer isShow;
    /** 项目总经费(万元） */
    @ApiModelProperty(value = "项目总经费(万元）", position = 39)
    private BigDecimal totalFunding;

    /** 评审状态 */
    private String stateName;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String appUnitName;

    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String appPersonName;

    /** 证件号 */
    @ExcelProperty("证件号")
    @ApiModelProperty(value = "证件号", position = 1)
    private String certId;
    /** 姓名 */
    @ExcelProperty("姓名")
    @ApiModelProperty(value = "姓名", position = 3)
    private String personName;
    /** 性别 */
    @ExcelProperty("性别")
    @ApiModelProperty(value = "性别", position = 4)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 5)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 7)
    private String title;
    /** 职称 */
    @ExcelProperty("职称")
    @ApiModelProperty(value = "职称", position = 15)
    private String titleName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8 )
    private String degree;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8)
    private String degreeName;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 10)
    private String mobile;
    /** 单位 */
    @ApiModelProperty(value = "单位", position = 13)
    private String unitName;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 13)
    private String workUnit;
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 13)
    private String username;
    /** 人才类别 */
    @ApiModelProperty(value = "人才类别")
    private String talentCategory;
    /** 人才类别名称 */
    @ApiModelProperty(value = "人才类别名称")
    private String talentCategoryName;

    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private String projName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    private String projNo;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 2 )
    private String appNo;
    /** 项目类型  1 科研项目  2重点学科项目 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private Integer systemType;
    /** 项目类别  1 一般项目  2重点项目 */
    @ApiModelProperty(value = "项目类别", position = 1 )
    private Integer projClass;
    /** 项目组名称 */
    @ApiModelProperty(value = "项目组名称", position = 1)
    private String groupName;
    /** 学科 */
    @ApiModelProperty(value = "学科", position = 16)
    private String knowledgeName;
    /** 评审专业 */
    @ApiModelProperty(value = "评审专业", position = 13)
    private List<ComExpertSpecDTO> specList;
}
