package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 用户信息表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "用户信息表VO")
public class SystemUser extends BaseEntity {

    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 1 , required = true)
    @NotNull(message = "用户名不能为空")
    @Length(max=100, message = "用户名不能大于100")
    private String username;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2 )
    @Length(max=100, message = "密码不能大于100")
    private String password;
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4 )
    @Length(max=36, message = "用户Id不能大于36")
    private String personId;
    /** 人员编码 */
    @ApiModelProperty(value = "人员编码", position = 22)
    private String personCode;
    /** 用户类型 */
    @ApiModelProperty(value = "用户类型", position = 5 )
    private Integer userType;
    /** 状态 */
    @ApiModelProperty(value = "状态", position = 6 )
    private Integer noteState;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 19 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;

}