package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目绩效指标表VO")
public class ComProjectKpitDetail extends BaseEntity {

    /** kpitId */
    @ApiModelProperty(value = "kpitId", position = 8)
    @Length(max=36, message = "kpitId不能大于36")
    private String kpitId;
    /** 绩效类型名称 */
    @ApiModelProperty(value = "绩效类型名称", position = 1 )
    @Length(max=200, message = "绩效类型名称不能大于200")
    private String kpitName;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 8)
    @Length(max=36, message = "项目Id不能大于36")
    private String objectId;
    /** 一级指标名称 */
    @ApiModelProperty(value = "一级指标名称", position = 1 )
    @Length(max=40, message = "一级指标名称不能大于40")
    private String oneLevelName;
    /** 二级指标名称 */
    @ApiModelProperty(value = "二级指标名称", position = 1 )
    @Length(max=40, message = "二级指标名称不能大于40")
    private String towLevelName;
    /** 指标值 */
    @ApiModelProperty(value = "指标值", position = 7)
    private Integer targetValue;
    /** 绩效标准 */
    @ApiModelProperty(value = "绩效标准", position = 7)
    private Integer performanceStandard;
    /** 年度1指标 */
    @ApiModelProperty(value = "年度1指标", position = 7)
    private Integer yearValue1;
    /** 年度2指标 */
    @ApiModelProperty(value = "年度2指标", position = 7)
    private Integer yearValue2;
    /** 年度3指标 */
    @ApiModelProperty(value = "年度3指标", position = 7)
    private Integer yearValue3;
    /** 一级指标显示 */
    @ApiModelProperty(value = "一级指标显示", position = 7)
    private Boolean oneDisplay;
    /** 二级指标显示 */
    @ApiModelProperty(value = "二级指标显示", position = 7)
    private Boolean towDisplay;
    /** 一级指标行合并数 */
    @ApiModelProperty(value = "一级指标行合并数", position = 7)
    private Integer oneRowSpan;
    /** 二级指标行合并数 */
    @ApiModelProperty(value = "二级指标行合并数", position = 7)
    private Integer towRowSpan;

}
