package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家项目分配表VO")
public class ComProjectAssign extends BaseEntity {
    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 1)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;
    /** 项目Id */
    @ApiModelProperty(value = "项目Id", position = 2)
    @Length(max=36, message = "项目Id不能大于36")
    private String projId;
    /** 专家类型（1技术专家、2财务专家） */
    @ApiModelProperty(value = "专家类型", position = 3)
    private Integer expertType;
    /** 分配年度 */
    @ApiModelProperty(value = "分配年度", position = 3)
    private Integer assignYear;
    /** score1 */
    @ApiModelProperty(value = "score1", position = 4)
    private BigDecimal score1;
    @ApiModelProperty(value = "score2", position = 4)
    private BigDecimal score2;
    @ApiModelProperty(value = "score3", position = 4)
    private BigDecimal score3;
    @ApiModelProperty(value = "score4", position = 4)
    private BigDecimal score4;
    @ApiModelProperty(value = "score5", position = 4)
    private BigDecimal score5;
    @ApiModelProperty(value = "score6", position = 4)
    private BigDecimal score6;
    @ApiModelProperty(value = "score7", position = 4)
    private BigDecimal score7;
    @ApiModelProperty(value = "score8", position = 4)
    private BigDecimal score8;
    @ApiModelProperty(value = "score9", position = 4)
    private BigDecimal score9;
    @ApiModelProperty(value = "score10", position = 4)
    private BigDecimal score10;
    @ApiModelProperty(value = "score11", position = 4)
    private BigDecimal score11;
    @ApiModelProperty(value = "score12", position = 4)
    private BigDecimal score12;
    @ApiModelProperty(value = "score13", position = 4)
    private BigDecimal score13;
    @ApiModelProperty(value = "score14", position = 4)
    private BigDecimal score14;
    @ApiModelProperty(value = "score15", position = 4)
    private BigDecimal score15;
    @ApiModelProperty(value = "score16", position = 4)
    private BigDecimal score16;
    @ApiModelProperty(value = "score17", position = 4)
    private BigDecimal score17;
    @ApiModelProperty(value = "score18", position = 4)
    private BigDecimal score18;
    @ApiModelProperty(value = "score19", position = 4)
    private BigDecimal score19;
    /** 附加项 */
    @ApiModelProperty(value = "附加项", position = 9)
    private BigDecimal additionalScore;
    /** 申请经费 */
    @ApiModelProperty(value = "申请经费", position = 9)
    private BigDecimal applyFunding;
    /** 建议财政支持经费 */
    @ApiModelProperty(value = "建议财政支持经费", position = 9)
    private BigDecimal recommendFunding;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 9)
    private BigDecimal totalScore;
    /** 备注 */
    @ApiModelProperty(value = "备注", position =10)
    @Length(max=65535, message = "备注不能大于65535")
    private String remark;
    /** 审核状态（0 未评审 1 保存 2 已提交） */
    @ApiModelProperty(value = "审核状态（0 未评审 1 保存 2 已提交）", position = 11)
    private Integer auditState;
    /** 是否支持立项（0 不支持 1 支持） */
    @ApiModelProperty(value = "审核状态（0 不支持 1 支持）", position = 11)
    private Integer supportState;
    /** 不推荐原因 */
    @ApiModelProperty(value = "不推荐原因", position = 11)
    private String noSupportReason;
    /** 评审类别（A通过(80分及以上)、B返回修改(60分及以上)、C不通过(60分以下)） */
    @ApiModelProperty(value = "评审类别", position = 11)
    private Integer evaluationType;
    /** 是否展示（0 不展示 1 展示） */
    @ApiModelProperty(value = "是否展示（0 不展示 1 展示）", position = 11)
    private Integer isShow;
}
