package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProject;
import com.yiboshi.science.entity.ComProjectAudit;
import com.yiboshi.science.param.dto.*;
import com.yiboshi.science.param.query.ComProjectAuditQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 审核表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectAuditDAO extends BaseMapper<ComProjectAudit>, BaseDAO<ComProjectAuditQueryVO, ComProjectAuditDTO, ComProjectAudit> {
    Page<ComProjectAuditDTO> getProjectAuditListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getTaskAuditListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getCheckAuditListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getConclusionAuditListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getTalentAuditListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getProjectStatisticListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getTaskStatisticListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getCheckStatisticListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Integer getMaxUnitLevelByObjectId(String objectId);
    int getMaxAuditIndex (String auditObjectId);
    DataStatisticsDTO getCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getConclusionAuditCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getTalentAuditCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getFirstAuditPassCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getCountByDay(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getAssignPersonCount(Integer assignYear, Integer systemType);
    List<DataStatisticsDTO> getTreeCodeProjectCount(@Param("ew") Wrapper<ComProject> queryWrapper,String treeCode);
    List<DataStatisticsDTO> getKnowledgeCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    List<KnowledgeStatisticsDTO> getKnowledgeStatistic(@Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper);
    Page<ComProjectAuditDTO> getUnAssignProjectListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper, Integer reportYear);
    Page<ComProjectAuditDTO> getUnAssignTalentListByPage(Page<ComProjectAuditQueryVO> page, @Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper, Integer reportYear);
    List<ComProjectGroupDetailDTO> getProjectGroupKnowledgeId(Integer groupYear);
    List<ComProjectAuditDTO> getAuditProjectList(@Param("ew") Wrapper<ComProject> queryWrapper);

    List<projectExpertGroupStatisticDTO> getProjectExpertGroupStatistic(@Param("ew") Wrapper<ComProjectAuditQueryVO> queryWrapper, Integer groupYear);
    List<ComPersonDTO> getExpertInfoByGroupId(String groupId);

    List<EvaluationStatisticDTO> getEvaluationStatistic(Integer reportYear);

    List<ProjectGroupScoreOrderDTO> getProjectGroupScoreOrder(Integer reportYear);

    List<TalentEvaluationStatisticDTO> getTalentEvaluationStatistic(Integer reportYear);

    List<TalentGroupScoreOrderDTO> getTalentGroupScoreOrder(Integer reportYear);
}
