package com.yiboshi.science.rest;

import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.BaseEntity;
import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.base.PaginationVO;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 包含CRUD操作的接口基类
 *
 * @author Negi
 * @version 2019-04
 */

@SuppressWarnings({"unused", "unchecked"})
public abstract class BaseController<T extends BaseService,Q extends PaginationVO,D extends BaseDTO, E extends BaseEntity> {

    @Autowired
    protected T baseService;

    @Autowired
    protected HttpServletRequest request;

    @Autowired
    protected HttpServletResponse response;

//    @ApiOperation(value = "2.01 新增", httpMethod = "POST", notes = "2.01 新增数据", consumes = MediaType.APPLICATION_JSON_VALUE)
//    @PostMapping
//    public ResponseDataModel doInsert(@Validated @RequestBody E e, BindingResult bindingResult) {
//        String id = baseService.insert(e);
//        return ResponseDataModel.ok(id);
//    }
//
//    @ApiOperation(value = "2.02 修改", httpMethod = "PUT", notes = "2.02 修改数据", consumes = MediaType.APPLICATION_JSON_VALUE)
//    @ApiImplicitParam(dataType = "string", name = "id", value = "主键", example = "1", type = "path")
//    @PutMapping(value = "/{id}")
//    public ResponseDataModel doUpdate(@PathVariable String id, @Validated @RequestBody E e, BindingResult bindingResult) {
//        e.setId(id);
//        baseService.update(e);
//        return ResponseDataModel.ok();
//    }

//    /**
//     * 屏蔽删除接口，尽量只做逻辑删除
//     * @param id
//     * @return
//     */
//    @ApiOperation(value = "2.04 数据删除", httpMethod = "DELETE", notes = "2.04 删除数据")
//    @ApiImplicitParam(dataType = "string", name = "id", value = "主键", example = "1", type = "path")
//    @DeleteMapping(value = "/{id}")
//    public ResponseDataModel doDelete(@PathVariable String id) {
//        baseService.deleteById(id);
//        return ResponseDataModel.ok();
//    }

//    /**
//     * 功能:分页查询
//     *
//     * @param vo  查询条件
//     */
//    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
//    @GetMapping
//    public ResponseDataModel<Pagination<D>> getListByPage(@Validated Q vo, BindingResult bindingResult) {
//        return ResponseDataModel.ok(baseService.queryPagination(vo));
//    }

}