package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComProjectResultsDAO;
import com.yiboshi.science.entity.ComProjectResults;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.param.dto.ComProjectResultsDTO;
import com.yiboshi.science.param.query.ComProjectResultsQueryVO;
import com.yiboshi.science.service.ComProjectResultsService;
import com.yiboshi.science.service.SystemParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 预期成果 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComProjectResultsServiceImpl extends BaseServiceImpl<ComProjectResultsDAO,ComProjectResultsQueryVO, ComProjectResultsDTO,ComProjectResults> implements ComProjectResultsService {

    @Autowired
    private ComProjectResultsDAO comProjectResultsDAO;

    @Autowired
    private SystemParameterService systemParameterService;

    @Override
    protected void setCriteriaForQuery(ComProjectResultsQueryVO vo, QueryWrapper<ComProjectResultsQueryVO> criteria) {
        if(Objects.nonNull(vo.getObjectId())){
            criteria.eq("object_id", vo.getObjectId());
        }
        if(Objects.nonNull(vo.getResultId())){
            criteria.eq("result_id", vo.getResultId());
        }
        if(Objects.nonNull(vo.getResultCount())){
            criteria.eq("result_count", vo.getResultCount());
        }
        if(Objects.nonNull(vo.getRemark())){
            criteria.eq("remark", vo.getRemark());
        }
    }

    public List<ComProjectResultsDTO> getListByObjectId(String objectId)
    {
        return comProjectResultsDAO.getListByObjectId(objectId);
    }
    public List<String> getArrayByObjectId(String objectId){
        return comProjectResultsDAO.getArrayByObjectId(objectId);
    }

    public List<String> getNameByObjectId(String objectId){
        return comProjectResultsDAO.getNameByObjectId(objectId);
    }
    public void deleteByObjectId(String objectId){
        ComProjectResults model = new ComProjectResults();
        model.setObjectId(objectId);
        this.delete(model);
    }

    public void insertList(List<String> list, String objectId) {
        ComProjectResults results = new ComProjectResults();
        results.setObjectId((objectId));
        this.delete(results);
        if (null != list) {
            List<ComProjectResults> iList = new ArrayList<>();
            for (int i = 0; i < list.size(); i++) {
                ComProjectResults item = new ComProjectResults();
                item.setResultId(list.get(i));
                item.setObjectId(objectId);
                iList.add(item);
            }
            this.insertBatch(iList);
        }
    }

    @Override
    public List<ComProjectResultsDTO> getList() {
        List<SystemParameter> list = systemParameterService.getListByType(50);
        List<ComProjectResultsDTO> results = new ArrayList<>();
        list.forEach((e) -> {
            ComProjectResultsDTO newVO = new ComProjectResultsDTO();
            newVO.setResultId(e.getId());
            newVO.setResultName(e.getName());
            newVO.setResultCount(0);
            results.add(newVO);
        });
        return results;
    }
}
