package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComExpertGroupDAO;
import com.yiboshi.science.entity.ComExpertGroup;
import com.yiboshi.science.param.dto.ComExpertGroupDTO;
import com.yiboshi.science.param.query.ComExpertGroupQueryVO;
import com.yiboshi.science.service.ComExpertGroupMembersService;
import com.yiboshi.science.service.ComExpertGroupService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Objects.isNull;

@Service
@AllArgsConstructor
public class ComExpertGroupServiceImpl extends BaseServiceImpl<ComExpertGroupDAO, ComExpertGroupQueryVO, ComExpertGroupDTO, ComExpertGroup> implements ComExpertGroupService {

    @Autowired
    private ComExpertGroupDAO comExpertGroupDAO;

    @Autowired
    private ComExpertGroupMembersService comExpertGroupMembersService;

    @Override
    protected void setCriteriaForQuery(ComExpertGroupQueryVO vo, QueryWrapper<ComExpertGroupQueryVO> criteria) {
        if (Objects.nonNull(vo.getName())) {
            criteria.like("a.name", vo.getName());
        }
        if (Objects.nonNull(vo.getYear())) {
            criteria.eq("b.year", vo.getYear());
        }
        if (Objects.nonNull(vo.getBatch())) {
            criteria.eq("b.batch", vo.getBatch());
        }
    }
    @Override
    protected void setCriteriaOrder(QueryWrapper<ComExpertGroup> criteria){
        criteria.orderByAsc("created");
    }

    @Override
    public Pagination<ComExpertGroupDTO> getListByPage(ComExpertGroupQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComExpertGroupQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComExpertGroupDTO> dtoList = comExpertGroupDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    @Transactional
    public void insertOrUpdateGroupList(List<ComExpertGroupDTO> expertGroup, String batchId) {
        ComExpertGroup comExpertGroup = new ComExpertGroup();
        comExpertGroup.setBatchId(batchId);
        final List<ComExpertGroup>[] list = new List[]{this.entityList(comExpertGroup)};
        expertGroup.forEach((e) -> {
            String groupId = "";
            ComExpertGroup ComExpertGroup = convert2Entity(e);
            if (Objects.nonNull(e.getId())) {
                groupId = this.update(ComExpertGroup);
                if (null != list[0] && list[0].size() > 0) {
                    list[0] = list[0].stream().filter(f -> !f.getId().equals(e.getId())).collect(Collectors.toList());
                }
            } else {
                ComExpertGroup.setBatchId(batchId);
                groupId = this.insert(ComExpertGroup);
            }
            if (Objects.nonNull(e.getMembers()) && e.getMembers().size() > 0) {
                comExpertGroupMembersService.insertMemberList(e.getMembers(), groupId);
            }
        });
        if (null != list[0] && list[0].size() > 0) {
            list[0].forEach((e) -> {
                comExpertGroupMembersService.deleteByGroupId(e.getId());
            });
        }
    }

    public List<ComExpertGroupDTO> getExpertGroupListByBatchId(String batchId) {
        ComExpertGroup comExpertGroup = new ComExpertGroup();
        comExpertGroup.setBatchId(batchId);
        List<ComExpertGroupDTO> list = this.dtoList(comExpertGroup);;
        if (null != list && list.size() > 0) {
            list.forEach((e) -> {
                if (!isNull(e)) {
                    e.setMembers(comExpertGroupMembersService.getExpertIdListByGroupId(e.getId()));
                }
            });
        }
        return list;
    }

    public List<ComExpertGroupDTO> getExpertGroupList() {
        ComExpertGroup entity = new ComExpertGroup();
        return this.dtoList(entity);
    }
}
