package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.ComEvaluationItemDAO;
import com.yiboshi.science.entity.ComEvaluationItem;
import com.yiboshi.science.param.dto.ComEvaluationDTO;
import com.yiboshi.science.param.dto.ComEvaluationItemDTO;
import com.yiboshi.science.param.query.ComEvaluationItemQueryVO;
import com.yiboshi.science.service.ComEvaluationItemService;
import com.yiboshi.science.service.ComEvaluationService;
import com.yiboshi.science.service.ComEvaluationValueService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class ComEvaluationItemServiceImpl extends BaseServiceImpl<ComEvaluationItemDAO, ComEvaluationItemQueryVO, ComEvaluationItemDTO, ComEvaluationItem> implements ComEvaluationItemService {

    @Autowired
    private ComEvaluationItemDAO comEvaluationItemDAO;

    @Autowired
    private ComEvaluationService comEvaluationService;

    @Override
    protected void setCriteriaForQuery(ComEvaluationItemQueryVO vo, QueryWrapper<ComEvaluationItemQueryVO> criteria) {

    }

    public List<ComEvaluationItemDTO> getListByEvaluationId() {
        ComEvaluationDTO dto = comEvaluationService.getEvaluation();
        if (null != dto) {
            return comEvaluationItemDAO.getListByEvaluationId(dto.getId());
        }
        return null;
    }
}
