package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComConclusionThesisDAO;
import com.yiboshi.science.entity.ComConclusionThesis;
import com.yiboshi.science.param.dto.ComConclusionThesisDTO;
import com.yiboshi.science.param.query.ComConclusionThesisQueryVO;
import com.yiboshi.science.service.ComConclusionThesisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 结题论文记录表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComConclusionThesisServiceImpl extends BaseServiceImpl<ComConclusionThesisDAO, ComConclusionThesisQueryVO, ComConclusionThesisDTO, ComConclusionThesis> implements ComConclusionThesisService {

    @Autowired
    private ComConclusionThesisDAO ComConclusionThesisDAO;

    @Override
    protected void setCriteriaForQuery(ComConclusionThesisQueryVO vo, QueryWrapper<ComConclusionThesisQueryVO> criteria) {
        if (Objects.nonNull(vo.getProjName())) {
            criteria.like("d.proj_name", vo.getProjName());
        }
        if (Objects.nonNull(vo.getProjNo())) {
            criteria.like("d.proj_no", vo.getProjNo());
        }
    }


    @Override
    public Pagination<ComConclusionThesisDTO> getListByPage(ComConclusionThesisQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComConclusionThesisQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComConclusionThesisDTO> dtoList = ComConclusionThesisDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    @Override
    public List<ComConclusionThesisDTO> getListByObjectId(String objectId) {
        List<ComConclusionThesisDTO> list = ComConclusionThesisDAO.getListByObjectId(objectId);
        return list;
    }

    @Override
    public void insertList(List<ComConclusionThesisDTO> list, String objectId) {
        ComConclusionThesis e = new ComConclusionThesis();
        e.setConclusionId(objectId);
        this.delete(e);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setConclusionId(objectId);
                    list.get(i).setShowIndex(i+1);
                    ComConclusionThesis model = convert2Entity(list.get(i));
                    this.insert(model);
                }
            }
        }
    }
}
