package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComBatch;
import com.yiboshi.science.param.dto.ComBatchDTO;
import com.yiboshi.science.param.query.ComBatchQueryVO;

import java.util.List;

/**
 *批次表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComBatchService extends BaseService<ComBatchQueryVO, ComBatchDTO, ComBatch>{

    List<ComBatchDTO> getBatchList(ComBatch entity);

    /**
     * 添加批次
     *
     * @param
     */
    String addBatch(ComBatchDTO dto);
    /**
     * 修改批次
     *
     * @param
     */
    String updateBatch(ComBatchDTO dto);
    /**
     * 删除批次
     *
     * @param
     */
    String deleteBatch(String id);
    /**
     * 根据Id获取批次
     *
     * @param id
     */
    ComBatchDTO getBatchById(String id);
    /**
     * 获取当前项目申报批次
     *
     * @param type
     * @param systemType
     */
    ComBatchDTO getCurrentYearBatch(int type,Integer systemType,Integer timeType);
    /**
     * 获取当前申报批次
     *
     * @param timeType
     * @param systemType
     */
    ComBatchDTO getCurrentBatch(Integer systemType,Integer timeType);
    /**
     * 获取当前申报年度
     *
     * @param systemType
     */
    Integer getReportYear(Integer systemType, Integer timeType);


}
