package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.config.annotation.Logs;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.entity.SystemParameterType;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.SystemParameterTypeDTO;
import com.yiboshi.science.param.query.SystemParameterTypeQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemParameterTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能：参数类型表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-parameter-type",description = "参数类型表")
@RestController
@RequestMapping("/v1/science-admin/system-parameter-type")
public class SystemParameterTypeController extends BaseController<SystemParameterTypeService,SystemParameterTypeQueryVO, SystemParameterTypeDTO, SystemParameterType> {

    @Autowired
    private SystemParameterTypeService systemParameterTypeService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<SystemParameterTypeDTO>> getListByPage(@Validated SystemParameterTypeQueryVO vo, BindingResult bindingResult) {
        Pagination<SystemParameterTypeDTO> page = systemParameterTypeService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "获取字典类型列表", httpMethod = "GET", notes = "获取字典类型列表")
    @GetMapping
    @RequestMapping("/getParameterTypeIdList")
    public ResponseDataModel<List<SelectListItem>> getParameterTypeIdList() {
        List<SelectListItem> list = new ArrayList<>();
        List<SystemParameterType> paraList = systemParameterTypeService.getParameterTypeList();
        paraList.forEach((e) -> {
            SelectListItem selectListItem = new SelectListItem(e.getName()+"("+e.getTypeId()+")", e.getTypeId().toString(),"",true, true, null);
            list.add(selectListItem);
        });
        return ResponseDataModel.ok(list);
    }

    /**
     * 根据id获取信息
     *
     * @param id 查询条件
     */
    @ApiOperation(value = "根据id获取信息", httpMethod = "GET", notes = "根据id获取信息")
    @GetMapping
    @RequestMapping("/getParameterTypeById")
    public ResponseDataModel<SystemParameterTypeDTO> getParameterTypeById(@Validated String id) {
        return ResponseDataModel.ok(systemParameterTypeService.dtoById(id));
    }

    @ApiOperation(value = "修改系统参数信息", httpMethod = "PUT", notes = "2.02 修改数据", consumes = MediaType.APPLICATION_JSON_VALUE)
    @ApiImplicitParam(dataType = "string", name = "id", value = "主键", example = "1", type = "path")
    @PutMapping(value = "/updateSystemParameterType")
    public ResponseDataModel<String> updateSystemParameterType(@Validated @RequestBody SystemParameterTypeDTO dto) {
        return ResponseDataModel.ok(systemParameterTypeService.save(dto));
    }

    @ApiOperation(value = "删除字典", httpMethod = "DELETE", notes = "删除字典")
    @DeleteMapping(value = "deleteById/{id}")
    @Logs(value = CommonEnum.logType.parameterDelete)
    public ResponseDataModel<String> deleteById(@PathVariable String id) {
        return ResponseDataModel.ok(systemParameterTypeService.deleteParameterTypeById(id));
    }
}
