package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.config.annotation.Anonymous;
import com.yiboshi.science.config.annotation.Logs;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.entity.SystemParameter;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.SpecDTO;
import com.yiboshi.science.param.dto.SystemParameterDTO;
import com.yiboshi.science.param.query.SystemParameterQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.SystemParameterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 功能：参数表 接口
 *
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "system-parameter", description = "参数表")
@RestController
@RequestMapping("/v1/science-admin/system-parameter")
public class SystemParameterController extends BaseController<SystemParameterService, SystemParameterQueryVO, SystemParameterDTO, SystemParameter> {

    @Autowired
    private SystemParameterService systemParameterService;


    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<SystemParameterDTO>> getListByPage(@Validated SystemParameterQueryVO vo, BindingResult bindingResult) {
        Pagination<SystemParameterDTO> page = systemParameterService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "根据类型获取父级参数列表", httpMethod = "GET", notes = "根据类型获取父级参数列表")
    @GetMapping
    @Anonymous
    @RequestMapping("/getParentListByType")
    public ResponseDataModel<List<SelectListItem>> getParentListByType(Integer typeId) {
        List<SelectListItem> list = new ArrayList<>();
        List<SystemParameter> paraList = systemParameterService.getParentListByType(typeId);
        paraList.forEach((e) -> {
            SelectListItem selectListItem = new SelectListItem(e.getName(), e.getId(),"",true, true, null);
            list.add(selectListItem);
        });
        return ResponseDataModel.ok(list);
    }

    @ApiOperation(value = "根据参数获取参数列表", httpMethod = "GET", notes = "根据参数获取参数列表")
    @GetMapping
    @Anonymous
    @RequestMapping("/getParameterList")
    public ResponseDataModel<Map<String, Object>> getParameterList(SystemParameter s) {
        return ResponseDataModel.ok(systemParameterService.getParameterList(s));
    }

    @ApiOperation(value = "根据参数获取参数列表", httpMethod = "GET", notes = "根据参数获取参数列表")
    @GetMapping
    @Anonymous
    @RequestMapping("/getParameterListByTypeId")
    public ResponseDataModel<List<SystemParameter>> getParameterListByTypeId(Integer typeId) {
        return ResponseDataModel.ok(systemParameterService.getListByType(typeId));
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @Anonymous
    @RequestMapping("/getArrayListByType")
    public ResponseDataModel<List<SelectListItem>> getArrayListByType(Integer typeId) {
        return ResponseDataModel.ok(systemParameterService.getArrayListByType(typeId));
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/getTreeListByType")
    public ResponseDataModel<List<SelectListItem>> getTreeListByType(Integer typeId) {
        return ResponseDataModel.ok(systemParameterService.getTreeListByType(typeId));
    }

    @ApiOperation(value = "获取父参数列表", httpMethod = "GET", notes = "获取父参数列表")
    @GetMapping
    @RequestMapping("/getParentList")
    public ResponseDataModel<List<SelectListItem>> getParentParameterList() {
        List<SelectListItem> list = new ArrayList<>();
        List<SystemParameter> paraList = systemParameterService.getParentParameterList();
        paraList.forEach((e) -> {
            SelectListItem selectListItem = new SelectListItem(e.getName()+"("+e.getTypeId()+")", e.getId(),"",true, true, null);
            list.add(selectListItem);
        });
        return ResponseDataModel.ok(list);
    }

    /**
     * 根据id获取信息
     *
     * @param id 查询条件
     */
    @ApiOperation(value = "根据id获取信息", httpMethod = "GET", notes = "根据id获取信息")
    @GetMapping
    @RequestMapping("/getParameterById")
    public ResponseDataModel<SystemParameterDTO> getParameterById(@Validated String id) {
        return ResponseDataModel.ok(systemParameterService.dtoById(id));
    }

    @ApiOperation(value = "修改字典", httpMethod = "PUT", notes = "2.02 修改数据", consumes = MediaType.APPLICATION_JSON_VALUE)
    @ApiImplicitParam(dataType = "string", name = "id", value = "主键", example = "1", type = "path")
    @PutMapping(value = "/updateSystemParameter")
    @Logs(value = CommonEnum.logType.parameterUpdate)
    public ResponseDataModel<String> updateSystemParameter(@Validated @RequestBody SystemParameterDTO dto) {
        return ResponseDataModel.ok(systemParameterService.save(dto));
    }

    @ApiOperation(value = "删除字典", httpMethod = "DELETE", notes = "删除字典")
    @DeleteMapping(value = "deleteById/{id}")
    @Logs(value = CommonEnum.logType.parameterDelete)
    public ResponseDataModel<String> deleteById(@PathVariable String id) {
        return ResponseDataModel.ok(systemParameterService.deleteParameterById(id));
    }

    @ApiOperation(value = "根据类型参数列表", httpMethod = "GET", notes = "根据类型参数列表")
    @GetMapping
    @RequestMapping("/refreshSystemParameter")
    public ResponseDataModel<String> refreshSystemParameter() {
        return ResponseDataModel.ok(systemParameterService.refreshSystemParameter());
    }

    @ApiOperation(value = "获取多级列表", httpMethod = "GET", notes = "获取多级列表")
    @GetMapping
    @RequestMapping("/getMultiLevelList")
    public ResponseDataModel<List<SelectListItem>> getMultiLevelList(Integer typeId) {
        List<SelectListItem> list = systemParameterService.getMultiLevelList(typeId);
        return ResponseDataModel.ok(list);
    }

    @ApiOperation(value = "获取多级Id列表", httpMethod = "GET", notes = "获取多级Id列表")
    @GetMapping
    @RequestMapping("/getMultiLevelIdList")
    public ResponseDataModel<List<SpecDTO>> getMultiLevelIdList(Integer typeId) {
        List<SpecDTO> list = systemParameterService.getMultiLevelIdList(typeId);
        return ResponseDataModel.ok(list);
    }
}
