package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.entity.ComNotice;
import com.yiboshi.science.param.dto.ComNoticeDTO;
import com.yiboshi.science.param.query.ComNoticeQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComNoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 功能：通知公告表 接口
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "com-notice",description = "通知公告表")
@RestController
@RequestMapping("/v1/science-admin/com-notice")
public class ComNoticeController extends BaseController<ComNoticeService, ComNoticeQueryVO, ComNoticeDTO, ComNotice> {
    @Autowired
    private ComNoticeService comNoticeService;

    @ApiOperation(value = "1.02 分页查询", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getListByPage")
    public ResponseDataModel<Pagination<ComNoticeDTO>> getListByPage(@Validated ComNoticeQueryVO vo, BindingResult bindingResult) {
        Pagination<ComNoticeDTO> page = comNoticeService.getListByPage(vo);
        return ResponseDataModel.ok(page);
    }

    @ApiOperation(value = "保存", httpMethod = "POST", notes = "保存")
    @PostMapping
    @RequestMapping("/save")
    public ResponseDataModel<String> save(@Validated @RequestBody ComNoticeDTO comNoticeDTO, BindingResult bindingResult) {
        return ResponseDataModel.ok(comNoticeService.save(comNoticeDTO));
    }

    @ApiOperation(value = "删除", httpMethod = "DELETE", notes = "删除")
    @DeleteMapping(value = "deleteById/{id}")
    public ResponseDataModel<String> deleteById(@PathVariable String id) {
        comNoticeService.deleteById(id);
        return ResponseDataModel.ok("success");
    }

    @ApiOperation(value = "通过Id获取信息", httpMethod = "GET", notes = "通过Id获取信息")
    @GetMapping
    @RequestMapping("/getById")
    public ResponseDataModel<ComNotice> getById(String id) {
        return ResponseDataModel.ok(comNoticeService.getById(id));
    }

    @ApiOperation(value = "获取最新通知", httpMethod = "GET", notes = "获取最新通知")
    @GetMapping
    @RequestMapping("/getLatestNotice")
    public ResponseDataModel<ComNoticeDTO> getLatestNotice() {
        return ResponseDataModel.ok(comNoticeService.getLatestNotice());
    }
}
