package com.yiboshi.science.rest.v1;

import com.yiboshi.arch.base.ResponseDataModel;
import com.yiboshi.science.config.annotation.Logs;
import com.yiboshi.science.entity.ComManager;
import com.yiboshi.science.entity.ComPerson;
import com.yiboshi.science.enumeration.CommonEnum;
import com.yiboshi.science.param.dto.ComManagerDTO;
import com.yiboshi.science.param.dto.ComPersonDTO;
import com.yiboshi.science.param.query.ComManagerQueryVO;
import com.yiboshi.science.rest.BaseController;
import com.yiboshi.science.service.ComManagerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 功能：单位管理员表 接口
 *
 * @author lkl
 * @version 2021-08-26
 */
@Api(tags = "com-manager", description = "单位管理员表")
@RestController
@RequestMapping("/v1/science-admin/com-manager")
public class ComManagerController extends BaseController<ComManagerService, ComManagerQueryVO, ComManagerDTO, ComManager> {
    @Autowired
    private ComManagerService comManagerService;

    /**
     * 功能:获取单位管理员
     *
     * @param id 查询条件
     */
    @ApiOperation(value = "获取单位管理员", httpMethod = "GET", notes = "1.02 根据参数获取列表")
    @GetMapping
    @RequestMapping("/getManagerListByUnitId")
    @PreAuthorize("hasAnyRole('UNIT','GOV','ADMIN')")
    public ResponseDataModel<List<ComPersonDTO>> getManagerListByUnitId(String id) {
        return ResponseDataModel.ok(comManagerService.getManagerListByUnitId(id));
    }

    @ApiOperation(value = "管理员添加", httpMethod = "POST", notes = "人员注册")
    @RequestMapping("/createManager")
    @PostMapping
    @Logs(value = CommonEnum.logType.managerAdd)
    public ResponseDataModel<String> createManager(@Validated @RequestBody ComManagerDTO dto) {
        return ResponseDataModel.ok(comManagerService.createManager(dto));
    }

    /**
     * 功能:修改管理员状态
     *
     * @param e 输入值
     */
    @ApiOperation(value = "1.02", httpMethod = "POST", notes = "1.02 修改管理员状态")
    @RequestMapping("/updateManagerState")
    @PostMapping
    @Logs(value = CommonEnum.logType.managerStateUpdate)
    public ResponseDataModel<String> updateManagerState(@RequestBody ComPerson e) {
        return ResponseDataModel.ok(comManagerService.updateManagerState(e.getId(), e.getPersonState()));
    }

    @ApiOperation(value = "删除单位管理员", httpMethod = "POST", notes = "删除单位管理员")
    @RequestMapping("/delete")
    @PostMapping
    @Logs(value = CommonEnum.logType.managerDelete)
    public ResponseDataModel<String> delete(@Validated @RequestBody ComPersonDTO dto) {
        return ResponseDataModel.ok(comManagerService.deleteManagerById(dto));
    }
}
