package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "人才分组表VO")
public class ComTalentGroupQueryVO extends PaginationVO {

    @ApiModelProperty(value = "人才分组名称", position = 1)
    @Length(max=60, message = "人才分组名称不能大于60")
    private String groupName;

    @ApiModelProperty(value = "人才分组年度", position = 2)
    private Integer groupYear;

    @ApiModelProperty(value = "人才分组排序", position = 2)
    private Integer displayOrder;

    @ApiModelProperty(value = "人才分组中的项目数", position = 4)
    private Integer talentCount;

    @ApiModelProperty(value = "人才分组中的专家数", position = 5)
    private Integer expertCount;

    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6)
    private Integer assignState;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 7)
    @Length(max=200, message = "备注不能大于200")
    private String remark;
}
