package com.yiboshi.science.param.query;

import com.yiboshi.science.base.BaseDTO;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 *  信息发送记录表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "信息发送记录表VO")
public class ComSendingRecordQueryVO extends PaginationVO {
    /** 发送类型 1注册 2人员审核 3单位审核 */
    @ApiModelProperty(value = "发送类型 1注册 2人员审核 3单位审核", position = 1 )
    private Integer sendType;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 2)
    @Length(max=36, message = "电话号码不能大于20")
    private String mobile;
    /** 发送状态 1成功  2失败 */
    @ApiModelProperty(value = "发送状态 1成功  2失败", position = 3 )
    private Integer state;
}