package com.yiboshi.science.param.query;

import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 *  通知公告表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "结题经费记录表VO")
public class ComNoticeQueryVO extends PaginationVO {
    /** 标题 */
    @ApiModelProperty(value = "标题", position = 1)
    @Length(max=36, message = "标题不能大于200")
    private String title;
    /** 内容 */
    @ApiModelProperty(value = "内容", position = 2)
    private String content;
}