package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 用户信息表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "用户信息表DTO")
public class SystemUserDTO extends BaseDTO {
    /** 用户名 */
    @ApiModelProperty(value = "用户名", position = 1)
    private String username;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2)
    private String password;
    /** 登录名 */
    @ApiModelProperty(value = "登录名", position = 3)
    private String loginName;
    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 4)
    private String personId;
    /** 人员编码 */
    @ApiModelProperty(value = "人员编码", position = 22)
    private String personCode;
    /** 用户类型 */
    @ApiModelProperty(value = "用户类型", position = 5)
    private Integer userType;
    /** 状态 */
    @ApiModelProperty(value = "状态", position = 6)
    private Integer noteState;
    /** 角色Id */
    @ApiModelProperty(value = "角色Id", position = 7)
    private String roles;

    /** 状态 */
    @ApiModelProperty(value = "状态", position = 22)
    private String stateName;

    /** 姓名 */
    private String personName;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 2)
    private String certId;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 5)
    private String sex;
    /** 出生日期 */
    @ApiModelProperty(value = "出生日期", position = 6)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 40)
    private String specName;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 37)
    private String nationName;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 35)
    private String educationName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 34)
    private String degreeName;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 33)
    private String titleName;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;

    /** 单位Id */
    @ApiModelProperty(value = "单位Id", position = 19)
    @Length(max=36, message = "单位Id不能大于36")
    private String unitId;
    /** 单位名称 */
    private String unitName;
    /** 状态 */
    private Integer unitState;
    /** 单位编码 */
    private String unitCode;

    /** 专家id */
    private String expertId;

    private List<String> role;
}