package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 项目表DTO
 *
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "项目表DTO")
public class ComProjectDTO extends BaseDTO {
    /** 项目名称 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private String projName;
    /** 项目名称(英文) */
    @ApiModelProperty(value = "项目名称(英文)", position = 1 )
    private String englishName;
    /** 项目编号 */
    @ApiModelProperty(value = "项目编号", position = 2 )
    private String projNo;
    /** 申请编号 */
    @ApiModelProperty(value = "申请编号", position = 4 )
    private String appNo;
    /** 版本号 */
    @ApiModelProperty(value = "版本号", position = 5 )
    private String versionNo;
    /** 申报单位Id */
    @ApiModelProperty(value = "申报单位Id", position = 8 )
    private String appUnitId;
    /** 申报人Id */
    @ApiModelProperty(value = "申报人Id", position = 9 )
    private String appPersonId;
    /** 申报年度 */
    @ApiModelProperty(value = "申报年度", position = 6 )
    private Integer reportYear;
    /** 申报批次 */
    @ApiModelProperty(value = "申报批次", position = 7 )
    private Integer batch;
    /** 主管处室 */
    @ApiModelProperty(value = "主管处室", position = 1)
    private String managerDept;
    /** 项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项 */
    @ApiModelProperty(value = "项目状态 -10 起草,10 待提交, 20 已提交至依托单位,25 依托单位审核通过，请打印申请书,30 返回修改,40 未批准立项,50 批准立项", position = 7 )
    private Integer projState;
    /** 项目类型  1 科研项目  2重点学科项目 */
    @ApiModelProperty(value = "项目名称", position = 1 )
    private Integer systemType;
    /** 项目类别 (1 一般项目 2重点项目)*/
    @ApiModelProperty(value = "项目类别 (1 一般项目 2重点项目)", position = 3 )
    private Integer projClass;
    /** 项目开始时间 */
    @ApiModelProperty(value = "项目开始时间", position = 10 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    /** 项目结束时间 */
    @ApiModelProperty(value = "项目结束时间", position = 11 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    /** 学科Id */
    @ApiModelProperty(value = "学科Id", position = 16 )
    private String knowledgeId;
    /** 专家/专家组是否评审完成  0否 1是 */
    @ApiModelProperty(value = "是否评审完成", position = 6 )
    private Integer completed;
    /** 分配状态 0未分配 1已分配 */
    @ApiModelProperty(value = "分配状态", position = 6 )
    private Integer assignState;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 4)
    private BigDecimal totalScore;
    /** 平均分 */
    @ApiModelProperty(value = "平均分", position = 4)
    private BigDecimal averageScore;
    /** 技术专家总分 */
    @ApiModelProperty(value = "技术专家总分", position = 4)
    private BigDecimal technologyScore;
    /** 技术专家平均分 */
    @ApiModelProperty(value = "技术专家平均分", position = 4)
    private BigDecimal technologyAverageScore;
    /** 财务专家总分 */
    @ApiModelProperty(value = "财务专家总分", position = 4)
    private BigDecimal economyScore;
    /** 财务专家平均分 */
    @ApiModelProperty(value = "财务专家平均分", position = 4)
    private BigDecimal economyAverageScore;
    /** 计算得分 */
    @ApiModelProperty(value = "计算得分", position = 4)
    private BigDecimal calculateScore;
    /** 答辩分数 */
    @ApiModelProperty(value = "答辩分数", position = 4)
    private BigDecimal defenseScore;

    /** 项目Id */
    @ApiModelProperty(value="项目Id")
    private String projId;

    /** 每年工作时间(月) */
    @ApiModelProperty(value = "每年工作时间(月)", position = 1 )
    private Integer jobTime;
    /** 主要研究领域 */
    @ApiModelProperty(value = "主要研究领域", position = 19 )
    private String mainResearchAreas;

    /** 单位联系人姓名 */
    @ApiModelProperty(value = "单位联系人姓名", position = 16)
    private String unitLinkName;
    /** 单位联系人手机 */
    @ApiModelProperty(value = "单位联系人手机", position = 16)
    private String unitLinkMobile;
    /** 单位电子邮箱 */
    @ApiModelProperty(value = "单位电子邮箱", position = 16)
    private String unitLinkEmail;
    /** 单位传真 */
    @ApiModelProperty(value = "单位传真", position = 16)
    private String unitLinkFax;

    /** 选题范围 */
    @ApiModelProperty(value = "选题范围", position = 1 )
    private String subjectScope;
    /** 项目摘要 */
    @ApiModelProperty(value = "项目摘要", position = 13 )
    private String projAbstract;
    /** 关键词 */
    @ApiModelProperty(value = "关键词", position = 26 )
    private String projKeywords;

    /** 项目总经费(万元） */
    @ApiModelProperty(value = "项目总经费(万元）", position = 39)
    private BigDecimal totalFunding;
    /** 申请科技经费(万元) */
    @ApiModelProperty(value = "申请科技经费(万元)", position = 40)
    private BigDecimal govFunding;
    /** 单位配套 */
    @ApiModelProperty(value = "单位配套", position = 41)
    private BigDecimal unitFunding;
    /** 自筹 */
    @ApiModelProperty(value = "自筹", position = 42)
    private BigDecimal selfFunding;
    /** 其他 */
    @ApiModelProperty(value = "其他", position = 43)
    private BigDecimal otherFunding;

    /** 项目实施目标 */
    @ApiModelProperty(value = "项目实施目标", position = 28 )
    private String researchContent;
    /** 主要技术指标 */
    @ApiModelProperty(value = "主要技术指标", position = 35 )
    private String technologyTarget;
    /** 主要经济指标 */
    @ApiModelProperty(value = "主要经济指标", position = 35 )
    private String economyTarget;
    /** 项目实施中形成的示范基地、中试线、生产线及其规模等 */
    @ApiModelProperty(value = "项目实施中形成的示范基地、中试线、生产线及其规模等", position = 35 )
    private String achievementTarget;
    /** 科技报告考核指标 */
    @ApiModelProperty(value = "科技报告考核指标", position = 35 )
    private String technologyReportsTarget;
    /** 其他应考核的指标 */
    @ApiModelProperty(value = "其他应考核的指标", position = 35 )
    private String otherTarget;

    @ApiModelProperty(value = "项目属性Id", position = 36)
    private String projAttribute;
    /** 年度总目标 */
    @ApiModelProperty(value = "年度总目标", position = 14 )
    private String yearTarget;
    /** 第一年目标 */
    @ApiModelProperty(value = "第一年目标", position = 14 )
    private String year1Goal;
    /** 第二年目标 */
    @ApiModelProperty(value = "第二年目标", position = 14 )
    private String year2Goal;
    /** 第三年目标 */
    @ApiModelProperty(value = "第三年目标", position = 14 )
    private String year3Goal;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 38 )
    private String remark;

    /** 项目完成状态 */
    @ApiModelProperty(value = "项目完成状态", position = 38 )
    private String completeStatus;

    /** 是否终审返回修改  0否 1是 */
    @ApiModelProperty(value = "是否终审返回修改", position = 6 )
    private Integer isFinalReturned;

    /** 项目步骤 */
    @ApiModelProperty(value = "项目步骤", position = 38 )
    private Integer step;

    /** 项目组成员_总人数 */
    @ApiModelProperty(value = "项目组成员_总人数", position = 17 )
    private Integer memCount;
    /** 项目组成员_高职 */
    @ApiModelProperty(value = "项目组成员_高职", position = 18 )
    private Integer memHighCount;
    /** 项目组成员_中职 */
    @ApiModelProperty(value = "项目组成员_中职", position = 19 )
    private Integer memMiddleCount;
    /** 项目组成员_初职 */
    @ApiModelProperty(value = "项目组成员_初职", position = 20 )
    private Integer memLowCount;
    /** 项目组成员_其他 */
    @ApiModelProperty(value = "项目组成员_其他", position = 21 )
    private Integer memOtherCount;
    /** 项目组成员_博士后 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBshCount;
    /** 项目组成员_博士生 */
    @ApiModelProperty(value = "项目组成员_博士研究生", position = 22 )
    private Integer memBsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_硕士研究生", position = 23 )
    private Integer memSsCount;
    /** 项目组成员_硕士生 */
    @ApiModelProperty(value = "项目组成员_学士", position = 24)
    private Integer memXsCount;
    /** 项目组成员_参加单位数 */
    @ApiModelProperty(value = "项目组成员_参加单位数", position = 25)
    private Integer workCount;

    /** 项目状态 */
    @ApiModelProperty(value = "项目状态", position = 41)
    private String projStateName;
    /** 项目类别 */
    @ApiModelProperty(value = "项目类别", position = 3)
    private String projClassName;
    /** 学科 */
    @ApiModelProperty(value = "学科", position = 16)
    private String knowledgeName;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 4 )
    private String fileId;
    /** 附件Id */
    @ApiModelProperty(value = "附件Id", position = 1 )
    private String downloadId;
    /** 附件名 */
    @ApiModelProperty(value = "附件名", position = 6)
    private String fileName;
    /** URL */
    @ApiModelProperty(value = "URL", position = 7)
    private String downloadUrl;
    /** 转换文件URL */
    @ApiModelProperty(value = "转换文件URL", position = 7)
    private String convertUrl;

    /** 单位 */
    @ApiModelProperty(value = "单位", position = 41)
    private String appUnitName;
    /** 注册单位类型 */
    @ApiModelProperty(value = "注册单位类型", position = 12)
    private String unitTypeName;

    /** 姓名 */
    @ApiModelProperty(value = "姓名", position = 41)
    private String appPersonName;
    /** 性别 */
    @ApiModelProperty(value = "性别", position = 3)
    private String sex;
    /** 出生年月 */
    @ApiModelProperty(value = "出生年月", position = 3)
    private Date birthday;
    /** 证件号 */
    @ApiModelProperty(value = "证件号", position = 3)
    private String certId;
    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;
    /** 电话号码 */
    @ApiModelProperty(value = "电话号码", position = 16)
    private String mobile;
    /** 地址 */
    @ApiModelProperty(value = "地址", position = 3)
    private String address;
    /** 民族 */
    @ApiModelProperty(value = "民族", position = 3)
    private String nationName;
    /** 职称 */
    @ApiModelProperty(value = "职称", position = 3)
    private String titleName;
    /** 职务 */
    @ApiModelProperty(value = "职务", position = 12)
    private String dutyName;
    /** 学位 */
    @ApiModelProperty(value = "学位", position = 8)
    private String degreeName;
    /** 学历 */
    @ApiModelProperty(value = "学历", position = 8)
    private String educationName;
    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 8)
    private String jobUnit;
    /** 专业 */
    @ApiModelProperty(value = "专业", position = 8)
    private String specName;

    /** 合作单位 */
    private List<ComProjectCooperativeUnitsDTO> cooperativeUnits;
    /** 项目主要参与单位 */
    private List<ComProjectCooperativeUnitsDTO> participateUnits;
    /** 项目组成员 */
    private List<ComProjectMembersDTO> members;
    /** 经费表 */
    private List<ComProjectBudgetDTO> budget;
    /** 年度用款计划 */
    private List<ComProjectFundPlanDTO> fundPlan;
    /** 购置设备预算明细表 */
    private List<ComProjectEquipmentDTO> deviceList;
    /** 单位支出明细预算 */
    private List<ComProjectUnitPaymentDTO> unitPayment;
    /** 项目绩效目标表 */
    private ProjectKPIStatisticDTO projectKPI;
    /** 项目安排及阶段目标 */
    private List<ComProjectStageGoalDTO> stageGoals;
    /** 项目课颖设置表 */
    private List<ComProjectSubDTO> projectSubList;
    /** 试制设备预算明细表 */
    private List<ComProjectManufactureDTO> manufactureList;
    /** 附件列表 */
    private List<ComFileDTO> fileList;
    /** 审核列表 */
    private List<ComProjectAuditNoteDTO> auditList;

}
