package com.yiboshi.science.enumeration;

public class CommonEnum {

    protected interface INumberEnum {
        Integer getCode();

        String getDescription();
    }

    protected interface ICharEnum {
        char getCode();

        String getDescription();
    }

    protected interface IStringEnum {
        String getKey();

        String getDescription();
    }

    /**
     * 系统级别
     */
    public enum unitLevel implements INumberEnum {

        province(125, "省级"),
        prefecture(124, "地州(市)级"),
        county(123, "县级"),
        towns(800, "乡镇级"),
        village(801, "村级"),
        none(0, "无");

        unitLevel(Integer number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static unitLevel getEnum(Integer value) {
            for (unitLevel e : unitLevel.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return unitLevel.none;//For values out of enum scope
        }
    }

    public enum timeType implements INumberEnum {
        projApply(1, "项目申报"),
        taskReport(2, "任务书上报"),
        middleCheck(3, "中期考核"),
        talentApply(4, "人才申报");

        timeType(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static timeType getEnum(Integer value) {
            for (timeType e : timeType.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return timeType.projApply;//For values out of enum scope
        }
    }

    public enum systemType implements INumberEnum {
        num(1, "卫生健康领域科技计划项目"),
        key(2, "公立医院高水平临床专科建设科技项目");

        systemType(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static systemType getEnum(Integer value) {
            for (systemType e : systemType.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return systemType.num;//For values out of enum scope
        }
    }

    /**
     * 单位类型
     */
    public enum unitType implements INumberEnum {
        gov(0, "行政单位"),
        hospital(1, "医疗机构"),
        other(3, "其它");

        unitType(Integer number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static unitType getEnum(Integer value) {
            for (unitType e : unitType.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return unitType.gov;//For values out of enum scope
        }
    }

    /**
     * 单位状态
     */
    public enum unitState implements INumberEnum {

        normal(1, "正常"),
        cancel(2, "注销"),
        delete(5, "删除");

        unitState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static unitState getEnum(Integer value) {
            for (unitState e : unitState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return unitState.normal;//For values out of enum scope
        }
    }

    /**
     * 系统角色
     */
    public enum systemRole implements INumberEnum {
        sys(4, "超级管理员"),
        topGov(0, "最高级行政单位管理员"),
        gov(1, "行政单位管理员"),
        unit(2, "医疗机构管理员"),
        personal(3, "立项用户"),
        expert(5, "专家");

        systemRole(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static systemRole getEnum(Integer value) {
            for (systemRole e : systemRole.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return systemRole.unit;//For values out of enum scope
        }
    }

    /**
     * 人员状态
     */
    public enum personState implements INumberEnum {
        normal(1, "正常"),
        cancel(2, "注销");
        personState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static personState getEnum(Integer value) {
            for (personState e : personState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return personState.normal;//For values out of enum scope
        }
    }

    /**
     * 专家状态
     */
    public enum loginState implements INumberEnum {
        start(1, "启用"),
        stop(2, "停用");

        loginState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static loginState getEnum(Integer value) {
            for (loginState e : loginState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return loginState.start;//For values out of enum scope
        }
    }

    /**
     * 用户状态
     */
    public enum userState implements INumberEnum {

        normal(1, "正常"),
        cancel(2, "注销");

        userState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static userState getEnum(Integer value) {
            for (userState e : userState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return userState.normal;//For values out of enum scope
        }
    }

    /**
     * 项目状态
     */
    public enum projState implements INumberEnum {
        draft(-10, "起草"),
        waitSubmit(10, "待提交"),
        toAudit(20, "评审中"),
        returnModify(30, "返回修改"),
        lastModify(35, "终审返回修改"),
        failed(40, "未批准立项"),
        pass(50, "批准立项"),
        report(55, "结题上报"),
        conclusion(60, "已结题");
        projState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static projState getEnum(Integer value) {
            for (projState e : projState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return projState.draft;//For values out of enum scope
        }
    }

    public enum talentState implements INumberEnum {
        draft(-10, "起草"),
        waitSubmit(10, "待提交"),
        toAudit(20, "审核中"),
        returnModify(30, "返回修改"),
        failed(40, "审核不通过"),
        pass(50, "审核通过");
        //report(55, "结题上报"),
        //conclusion(60, "已结题");
        talentState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static talentState getEnum(Integer value) {
            for (talentState e : talentState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return talentState.draft;//For values out of enum scope
        }
    }

    /**
     * 论文上传状态
     */
    public enum thesisState implements INumberEnum {
        unFilled(0, "未上传"),
        waitAudit(1, "待审核"),
        pass(10, "通过"),
        returnModify(30, "返回修改"),
        failed(20, "不通过");
        thesisState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static thesisState getEnum(Integer value) {
            for (thesisState e : thesisState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return thesisState.unFilled;//For values out of enum scope
        }
    }


    /**
     * 结题状态
     */
    public enum conclusionState implements INumberEnum {
        unFilled(0, "未填报"),
        draft(1, "起草"),
        waitSubmit(10, "待上报"),
        report(20, "已上报"),
        returnModify(30, "返回修改"),
        failed(40, "不通过"),
        pass(50, "已通过");
        conclusionState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static conclusionState getEnum(Integer value) {
            for (conclusionState e : conclusionState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return conclusionState.unFilled;//For values out of enum scope
        }
    }

    /**
     * 任务书状态
     */
    public enum taskState implements INumberEnum {
        noWrite(0, "未填写"),
        draft(-10, "起草"),
        waitSubmit(10, "待提交"),
        review(20, "审核中"),
        returnModify(30, "返回修改"),
        failed(40, "审核不通过"),
        pass(50, "审核通过");

        taskState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static taskState getEnum(Integer value) {
            for (taskState e : taskState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return taskState.noWrite;//For values out of enum scope
        }
    }

    /**
     * 中期考核状态
     */
    public enum checkState implements INumberEnum {
        noSubmit(1, "未上报"),
        review(5, "审核中"),
        returnModify(30, "返回修改"),
        failed(20, "审核不通过"),
        pass(10, "审核通过");

        checkState(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static checkState getEnum(Integer value) {
            for (checkState e : checkState.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return checkState.noSubmit;//For values out of enum scope
        }
    }

    /**
     * 审核结果
     */
    public enum auditResult implements INumberEnum {
        waitAudit(1, "待审核"),
        returnModify(30, "返回修改"),
        failed(20, "审核不通过"),
        pass(10, "审核通过");

        auditResult(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static auditResult getEnum(Integer value) {
            for (auditResult e : auditResult.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return auditResult.waitAudit;//For values out of enum scope
        }
    }

    public enum auditMethod implements INumberEnum {
        audit(1, "审核"),
        last(5, "终审");

        auditMethod(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static auditMethod getEnum(Integer value) {
            for (auditMethod e : auditMethod.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return auditMethod.audit;//For values out of enum scope
        }
    }

    /**
     * 审核类型
     */
    public enum auditType implements INumberEnum {
        project(1, "项目审核"),
        task(2, "任务书审核"),
        check(3, "中期考核审核"),
        conclusion(4, "结题审核"),
        thesis(5, "论文审核"),
        talent(6, "人才申报审核");

        auditType(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static auditType getEnum(Integer value) {
            for (auditType e : auditType.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return auditType.check;
        }
    }

    /**
     * 日志类型
     */
    public enum logType implements IStringEnum {
        nullValue("nullValue", "空值"),
        userLogin("userLogin", "用户登录"),
        userRegister("userRegister", "用户注册"),
        userAudit("userAudit", "用户审核"),
        userReset("userReset", "重置密码"),
        sendVerificationCode("sendVerificationCode", "发送验证码"),

        personUpdate("personUpdate", "人员信息修改"),
        personInfoUpdate("personInfoUpdate", "人员信息修改(后台)"),
        personStateUpdate("personStateUpdate", "人员状态修改"),

        userStateUpdate("userStateUpdate", "用户状态修改"),

        expertAdd("expertAdd", "添加专家"),
        expertStateUpdate("expertStateUpdate", "专家状态修改"),
        expertUpdate("expertUpdate", "专家修改"),
        expertReport("expertReport", "专家上报"),
        expertDelete("expertDelete", "删除专家"),

        managerAdd("managerAdd", "添加管理员"),
        managerStateUpdate("managerAdd", "修改管理员状态"),
        managerDelete("managerDelete", "删除管理员"),

        unitRegister("unitRegister", "单位注册"),
        unitAudit("unitAudit", "单位审核"),
        unitAdd("unitAdd", "单位添加"),
        unitUpdate("unitUpdate", "单位信息修改"),
        unitStateUpdate("unitStateUpdate", "单位状态修改"),
        unitDelete("unitDelete", "单位删除"),

        projectSave("projectSave", "项目信息保存"),
        projectComplete("projectComplete", "项目完成填写"),
        projectReport("projectReport", "项目上报"),
        projectAudit("projectAudit", "项目审核"),
        projectDelete("projectDelete", "项目删除"),
        projectAssign("projectAssign", "项目分配"),
        assignDelete("assignDelete", "删除评分记录"),

        taskSave("taskBookSave", "任务书保存"),
        taskReport("taskBookReport", "合同书上报"),
        taskAudit("taskBookAudit", "合同书审核"),

        conclusionSave("conclusionSave", "结题信息保存"),
        conclusionReport("conclusionReport", "结题上报"),
        conclusionAudit("conclusionAudit", "结题审核"),

        appUnitUpdate("appUnitUpdate", "申报单位修改"),

        thesisAudit("thesisAudit", "论文审核"),

        batchAdd("batchAdd", "批次添加"),
        batchUpdate("batchUpdate", "批次删除"),
        batchDelete("batchDelete", "批次修改"),

        checkReport("checkReport", "中期考核上报"),
        checkAudit("checkAudit", "中期考核表审核"),

        fileUpload("fileUpload", "文件上传"),
        fileDelete("fileDelete", "文件删除"),

        parameterUpdate("parameterUpdate", "保存字典"),
        parameterDelete("parameterDelete", "删除字典"),

        auditRecordDelete("auditRecordSave", "删除评审记录"),
        auditRecordSave("auditRecordSave", "修改/添加评审记录"),

        talentApplySave("talentApply", "人才申报保存"),
        talentApplyComplete("talentApplyComplete", "人才申报完成填写"),
        talentApplyReport("talentApplyReport", "人才申报信息上报"),
        talentApplyAudit("talentApplyAudit", "人才申报信息审核"),
        talentApplyDelete("talentApplyDelete", "人才申报信息删除"),
        talentAssign("talentAssign", "人才分配");

        logType(String key, String description) {
            this.key = key;
            this.description = description;
        }

        private String key;
        private String description;

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static logType getEnum(String value) {
            for (logType e : logType.values()) {
                if (e.getKey().equals(value))
                    return e;
            }
            return logType.nullValue;//For values out of enum scope
        }
    }

    /**
     * 文件类型
     */
    public enum fileType implements INumberEnum {

        project(10, "项目附件"),
        Conclusion(20, "结题附件"),
        reviewOpinions(30, "学术委员会审查意见"),
        projectTask(40, "任务书文件"),
        talentApply(50, "人才申报");

        fileType(int number, String description) {
            this.code = number;
            this.description = description;
        }

        private Integer code;
        private String description;

        @Override
        public Integer getCode() {
            return code;
        }

        @Override
        public String getDescription() {
            return description;
        }

        public static fileType getEnum(Integer value) {
            for (fileType e : fileType.values()) {
                if (e.getCode().equals(value))
                    return e;
            }
            return fileType.project;//For values out of enum scope
        }
    }
}
