package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 操作日志表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "操作日志表VO")
public class LogsOperation extends BaseEntity {
    /** 操作人Id */
    @ApiModelProperty(value = "操作人Id", position = 1 )
    @Length(max=36, message = "操作人Id不能大于36")
    private String customerId;
    /** 关键字 */
    @ApiModelProperty(value = "关键字", position = 2 )
    @Length(max=200, message = "关键字不能大于200")
    private String logKey;
    /** 日志参数 */
    @ApiModelProperty(value = "日志参数", position = 3)
//    @Length(max=1000, message = "关键字不能大于200")
    private String logParam;
    /** 请求地址 */
    @ApiModelProperty(value = "请求地址", position = 6)
    @Length(max=500, message = "日志内容不能大于200")
    private String requestUrl;
    /** 用户浏览器信息 */
    @ApiModelProperty(value = "用户浏览器信息", position = 5 , required = true)
    @NotNull(message = "用户浏览器信息不能为空")
    @Length(max=200, message = "用户浏览器信息不能大于200")
    private String browser;
    /** 用户IP */
    @ApiModelProperty(value = "用户IP", position = 6 )
    @Length(max=200, message = "用户IP不能大于200")
    private String ipAddress;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 4 )
    @Length(max=100, message = "备注不能大于100")
    private String remark;
}