package com.yiboshi.science.entity;

import com.yiboshi.science.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "评审分值表")
public class ComEvaluationValue extends BaseEntity {
    /** 专家分配表Id */
    @ApiModelProperty(value = "专家分配表Id", position = 1)
    @Length(max=36, message = "专家分配表Id不能大于36")
    private String assignId;
    /** 值对象Id */
    @ApiModelProperty(value = "值对象Id", position = 1)
    @Length(max=36, message = "值对象Id不能大于36")
    private String itemId;
    /** 明细 */
    @ApiModelProperty(value = "明细", position = 2)
    @Length(max=200, message = "明细不能大于200")
    private String detail;
    /** 数量 */
    @ApiModelProperty(value = "数量", position = 2)
    private BigDecimal count;
    /** 总分 */
    @ApiModelProperty(value = "总分", position = 3)
    private BigDecimal score;
}
