package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComProject;
import com.yiboshi.science.entity.ComUnit;
import com.yiboshi.science.param.dto.ComUnitDTO;
import com.yiboshi.science.param.dto.DataStatisticsDTO;
import com.yiboshi.science.param.query.ComUnitQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 单位表 DAO
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComUnitDAO extends BaseMapper<ComUnit>, BaseDAO<ComUnitQueryVO, ComUnitDTO,ComUnit> {
    String getMaxTreeCode (String Code);
    ComUnitDTO getUnitById(String id);
    ComUnitDTO getTopUnit(int len);
    ComUnitDTO getUnitByTreeCode(String treeCode);
    List<ComUnitDTO> getList();
    List<ComUnitDTO> getListByUnitName(String UnitName);
    DataStatisticsDTO getRegisterUnitCount(@Param("ew") Wrapper<ComProject> queryWrapper);
    DataStatisticsDTO getRegisterUnitCountByDay(@Param("ew") Wrapper<ComProject> queryWrapper);

}
