package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.AssignCount;
import com.yiboshi.science.entity.ComTalentAssign;
import com.yiboshi.science.param.dto.ComTalentAssignDTO;
import com.yiboshi.science.param.dto.ComTalentGroupDTO;
import com.yiboshi.science.param.query.ComTalentAssignQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人才专家分配明细表
 */
public interface ComTalentAssignDAO extends BaseMapper<ComTalentAssign>, BaseDAO<ComTalentAssignQueryVO, ComTalentAssignDTO, ComTalentAssign> {

    List<ComTalentAssignDTO> getAssignExpertList(String projectId);

    ComTalentAssignDTO getAssignExpertById(String id);

    List<AssignCount> getAssignCount(String expertId);

    List<ComTalentGroupDTO> getTalentGroupAssignById(String id, String expertId);
}
