package com.yiboshi.science.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yiboshi.science.base.BaseDAO;
import com.yiboshi.science.entity.ComExpertSpec;
import com.yiboshi.science.entity.SystemMenu;
import com.yiboshi.science.param.dto.ComExpertDTO;
import com.yiboshi.science.param.dto.ComExpertSpecDTO;
import com.yiboshi.science.param.query.ComExpertSpecQueryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface ComExpertSpecDAO extends BaseMapper<ComExpertSpec>, BaseDAO<ComExpertSpecQueryVO, ComExpertSpecDTO, ComExpertSpec> {

    List<String> getIdListByExpertId(String expertId);

    List<ComExpertSpecDTO> getListByExpertId(String expertId);

    List<ComExpertDTO> getExpertListBySpecId(@Param("ew") Wrapper<SystemMenu> queryWrapper);

    List<ComExpertDTO> getExpertListBySpecIdProjId(@Param("specIds") List<String> SpecList, @Param("porjIds") List<String> ProjList);

    List<ComExpertDTO> getExpertListByExpertSpecIds(@Param("specIds") List<String> specIds, @Param("personName") String personName);

    List<ComExpertDTO> getExpertListByExpertSpecIdOrParentId(@Param("specId") String specId, @Param("pkey") String pkey, @Param("ppkey") String ppkey, @Param("personName") String personName);
}
