package com.yiboshi.science.config.security;

import com.yiboshi.arch.exception.BusinessException;
import com.yiboshi.science.enumeration.CommonEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

;

/**
 * 获取当前登录的用户
 *
 * @author kylin
 * @date 2021-11-17
 */
@Slf4j
@Component
public class SecurityUserHolder {

    /**
     * 获取系统用户名称
     *
     * @return 系统用户
     */
    public static SecurityUser getCurrentUser() {
        final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new BusinessException("Login expired or not logged in！");
        }
        if (authentication.getPrincipal() instanceof SecurityUser) {
            SecurityUser securityUser = (SecurityUser) authentication.getPrincipal();
            return securityUser;
        }
        throw new BusinessException("Login expired or not logged in！");
    }

    /**
     * 获取系统人员ID
     *
     * @return
     */
    public static String getPersonId() {
        return getCurrentUser().getPersonId();
    }
    /**
     * 获取系统用户ID
     *
     * @return
     */
    public static String getUserId() {
        return getCurrentUser().getUserId();
    }

    /**
     * 获取专家ID
     *
     * @return
     */
    public static String getExpertId() {
        return getCurrentUser().getExpertId();
    }

    /**
     * 获取系统单位ID
     *
     * @return
     */
    public static String getUnitId() {
        return getCurrentUser().getUnitId();
    }

    /**
     * 获取系统单位treeCode
     *
     * @return
     */
    public static String getUnitCode() {
        return getCurrentUser().getUnitCode();
    }

    /**
     * 获取RoleId
     *
     * @return
     */
    public static String getRoles() {
        return getCurrentUser().getRoles();
    }

    /**
     * 获取Token
     *
     * @return
     */
    public static String getToken() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String bearerToken = request.getHeader("Authorization");
        String tokenHead = "Bearer ";
        if (StringUtils.hasText(bearerToken) && bearerToken.startsWith(tokenHead)) {
            // 去掉令牌前缀
            return bearerToken.replace(tokenHead, "");
        } else {
            bearerToken = request.getParameter("access_token");
            if (StringUtils.hasText(bearerToken) && bearerToken.startsWith(tokenHead)) {
                // 去掉令牌前缀
                return bearerToken.replace(tokenHead, "");
            }
        }
        return null;
    }

    public static String getAuthType() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String authType = request.getHeader("Auth-Type");
        if (StringUtils.hasText(authType))
            return authType;
        else
            return null;
    }

    public static boolean isKeyDiscipline() {
        if (null != getAuthType() && getAuthType().equals("2"))
            return true;
        else
            return false;
    }

    public static int projectType() {
        if (null != getAuthType() && getAuthType().equals("2"))
            return CommonEnum.systemType.key.getCode();
        else
            return CommonEnum.systemType.num.getCode();
    }
}
