package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.dao.SystemUserRoleDAO;
import com.yiboshi.science.entity.SystemUserRole;
import com.yiboshi.science.param.dto.SystemUserDTO;
import com.yiboshi.science.param.dto.SystemUserRoleDTO;
import com.yiboshi.science.param.query.SystemUserRoleQueryVO;
import com.yiboshi.science.service.SystemUserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 用户角色表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class SystemUserRoleServiceImpl extends BaseServiceImpl<SystemUserRoleDAO, SystemUserRoleQueryVO, SystemUserRoleDTO, SystemUserRole> implements SystemUserRoleService {

    @Autowired
    private SystemUserRoleDAO systemUserRoleDAO;

    @Override
    protected void setCriteriaForQuery(SystemUserRoleQueryVO vo, QueryWrapper<SystemUserRoleQueryVO> criteria) {

    }

    public String getRolesByUserId(String userId) {
        String roles="";
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setUserId(userId);
        systemUserRole.setState(1);
        List<SystemUserRole> list = this.entityList(systemUserRole);
        for (SystemUserRole e : list) {
            roles = roles + "," + e.getRoleId();
        }
        if (!roles.equals("")) {
            roles = roles.substring(1);
        }
        return roles;
    }

    public List<String> getRolesListByUserId(String userId) {
        List<String> list =new ArrayList<>();
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setUserId(userId);
        List<SystemUserRole> item = this.entityList(systemUserRole);
        for (SystemUserRole e : item) {
            list.add(e.getRoleId());
        }
        return list;
    }

    public void addRoleByUserId(String userId, String roleId) {
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setRoleId(roleId);
        systemUserRole.setUserId(userId);
        systemUserRole = this.getEntity(systemUserRole);
        if (null == systemUserRole) {
            systemUserRole = new SystemUserRole();
            systemUserRole.setRoleId(roleId);
            systemUserRole.setUserId(userId);
            systemUserRole.setState(1);
            this.insert(systemUserRole);
        }
    }

    public void deleteRoleByUserId(String userId, String role) {
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setUserId(userId);
        systemUserRole.setRoleId(role);
        this.delete(systemUserRole);
    }

    public String updateStateById(String id, Integer state) {
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setId(id);
        systemUserRole.setState(state);
        return this.update(systemUserRole);
    }

    public void updateRoleByUserId(String userId, String id, String roleId) {
        SystemUserRole systemUserRole = new SystemUserRole();
        systemUserRole.setUserId(userId);
        systemUserRole.setRoleId(roleId);
        systemUserRole = this.getEntity(systemUserRole);
        if (null == systemUserRole) {
            systemUserRole = new SystemUserRole();
            systemUserRole.setId(id);
            systemUserRole.setRoleId(roleId);
            this.update(systemUserRole);
        }
    }

    public void addRoleByPersonId(String personId, String role) {
        List<SystemUserRoleDTO> list = systemUserRoleDAO.getRoleListByPersonId(personId, role);
        for (SystemUserRoleDTO e : list) {
            this.addRoleByUserId(e.getUserId(), role);
        }
    }

    public SystemUserDTO getUserRoleByCertId(String certId, String roleId) {
        return systemUserRoleDAO.getUserRoleByCertId(certId, roleId);
    }
}
