package com.yiboshi.science.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yiboshi.science.base.BaseServiceImpl;
import com.yiboshi.science.base.Pagination;
import com.yiboshi.science.dao.ComConclusionCatalogDAO;
import com.yiboshi.science.entity.ComConclusionCatalog;
import com.yiboshi.science.param.dto.ComConclusionCatalogDTO;
import com.yiboshi.science.param.query.ComConclusionCatalogQueryVO;
import com.yiboshi.science.service.ComConclusionCatalogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 验收材料目录表 Service 实现类
 *
 * @author lkl
 * @version 2021-08-26
 */
@Service
public class ComConclusionCatalogServiceImpl extends BaseServiceImpl<ComConclusionCatalogDAO, ComConclusionCatalogQueryVO, ComConclusionCatalogDTO, ComConclusionCatalog> implements ComConclusionCatalogService {

    @Autowired
    private ComConclusionCatalogDAO ComConclusionCatalogDAO;

    @Override
    protected void setCriteriaForQuery(ComConclusionCatalogQueryVO vo, QueryWrapper<ComConclusionCatalogQueryVO> criteria) {

    }

    @Override
    public Pagination<ComConclusionCatalogDTO> getListByPage(ComConclusionCatalogQueryVO vo) {
        QueryWrapper criteria = new QueryWrapper();
        setCriteriaForQuery(vo, criteria);
        Page<ComConclusionCatalogQueryVO> page = new Page<>(vo.getPageIndex(), vo.getPageSize());
        List<ComConclusionCatalogDTO> dtoList = ComConclusionCatalogDAO.getListByPage(page, criteria).getRecords();
        return new Pagination<>(dtoList, page.getTotal(), vo.getPageSize());
    }

    @Override
    public List<ComConclusionCatalogDTO> getListByObjectId(String objectId) {
        List<ComConclusionCatalogDTO> list = ComConclusionCatalogDAO.getListByObjectId(objectId);
        return list;
    }

    @Override
    public void insertList(List<ComConclusionCatalogDTO> list, String objectId) {
        ComConclusionCatalog e = new ComConclusionCatalog();
        e.setConclusionId(objectId);
        this.delete(e);
        if (null != list) {
            for (int i = 0; i < list.size(); i++) {
                if (!isObjectNull(list.get(i))) {
                    list.get(i).setConclusionId(objectId);
                    list.get(i).setShowIndex(i+1);
                    ComConclusionCatalog model = convert2Entity(list.get(i));
                    this.insert(model);
                }
            }
        }
    }
}
