package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComProjectEquipment;
import com.yiboshi.science.param.dto.ComProjectEquipmentDTO;
import com.yiboshi.science.param.query.ComProjectEquipmentQueryVO;

import java.util.List;

/**
 *设备仪器经费表 Service
 *
 * @author lkl
 * @version 2021-08-26
 */
public interface ComProjectEquipmentService extends BaseService<ComProjectEquipmentQueryVO, ComProjectEquipmentDTO, ComProjectEquipment> {

    /** 根据对象获取经费列表
     *
     * @param objectId
     * @return
     */
    List<ComProjectEquipmentDTO> getListByObjectId(String objectId);

    /**插入经费表
     *
     * @param budgetList
     * @param objectId
     */
    void insertEquipmentList(List<ComProjectEquipmentDTO> budgetList, String objectId);

    /** 删除对象列表
     *
     * @param objectId
     */
    void deleteByObjectId(String objectId);
}
