package com.yiboshi.science.service;

import com.yiboshi.science.base.BaseService;
import com.yiboshi.science.entity.ComExpertSpec;
import com.yiboshi.science.entity.SelectListItem;
import com.yiboshi.science.param.dto.ComExpertSpecDTO;
import com.yiboshi.science.param.query.ComExpertSpecQueryVO;

import java.util.List;
import java.util.Map;


public interface ComExpertSpecService extends BaseService<ComExpertSpecQueryVO, ComExpertSpecDTO, ComExpertSpec>{
    /** 根据专家Id 获取专业列表
     *
     * @param expertId
     */
    List<String> getIdListByExpertId(String expertId);
    /** 根据专家Id 获取专业列表
     *
     * @param expertId
     */
    List<ComExpertSpecDTO> getListByExpertId(String expertId);

    /** 判断是1技术专家、2财务专家
     *
     * @param expertId
     * @return
     */
    Integer getExpertTypeByExpertId(String expertId);

    /** 插入列表
     *
     * @param list
     * @param expertId
     */
    void insertSpecList(List<ComExpertSpecDTO> list, String expertId);
    /**
     * 根据参数获取参数列表
     *
     * @param specId
     * @return
     */
    List<SelectListItem> getExpertListBySpecId(Map<String, Object> specId);
    /** 根据 项目Id 获取专家列表
     *
     * @param SpecList
     * @param ProjList
     */
    List<SelectListItem> getExpertListBySpecIdProjId(List<String> SpecList, List<String> ProjList);
    /** 根据 项目Id 获取专家列表
     *
     * @param groupIds
     */
    List<SelectListItem> getExpertListByExpertSpecIds(List<String> specIds,List<String> groupIds, String personName);

    /**
     * 根据学科Id获取专家列表
     * @param specId
     * @param pkey
     * @param ppkey
     * @param personName
     * @return
     */
    List<SelectListItem> getExpertListByExpertSpecIdOrParentId(String specId, String pkey, String ppkey, String personName);
}
