package com.yiboshi.science.param.query;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 查询参数表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询参数表VO")
public class SystemParameterQueryVO extends PaginationVO{
    /** 参数类型 */
    @ApiModelProperty(value = "参数类型", position = 1)
    private Integer typeId;
    /** 父Id */
    @ApiModelProperty(value = "父Id", position = 2)
    private String parentId;
    /** 参数名称 */
    @ApiModelProperty(value = "参数名称", position = 3)
    private String name;
    /** 编码 */
    @ApiModelProperty(value = "编码", position = 4)
    private String code;
    /** 标准编码 */
    @ApiModelProperty(value = "标准编码", position = 4)
    private String gbCode;
    /** 树编码 */
    @ApiModelProperty(value = "树编码", position = 5)
    private String treeCode;
    /** 系统编码 */
    @ApiModelProperty(value = "系统编码", position = 8)
    private String systemCode;
    /** 显示顺序 */
    @ApiModelProperty(value = "显示顺序", position = 6)
    private Integer displayOrder;
    /** 状态 */
    @ApiModelProperty(value = "状态", position = 7)
    private Integer noteState;
    /** 是否为必填项 */
    @ApiModelProperty(value = "是否为必填项", position = 8)
    private Boolean isRequired;
}