package com.yiboshi.science.param.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.PaginationVO;
import com.yiboshi.science.param.dto.ComPersonDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 查询单位表VO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "查询单位表VO")
public class ComUnitQueryVO extends PaginationVO{
    /** 树编码 */
    @ApiModelProperty(value = "树编码", position = 1 , required = true)
    @NotNull(message = "树编码不能为空")
    @Length(max=50, message = "树编码不能大于50")
    private String treeCode;
    /** 单位名称 */
    @ApiModelProperty(value = "单位名称", position = 2 )
    @Length(max=200, message = "单位名称不能大于200")
    private String unitName;
    /** 单位类型 */
    @ApiModelProperty(value = "单位类型", position = 3 )
    private Integer unitType;
    /** 单位性质 */
    @ApiModelProperty(value = "单位性质", position = 3 )
    private String unitNature;
    /** 状态 1正常 2 注销 */
    @ApiModelProperty(value = "状态 1正常 2 注销", position = 5)
    private Integer unitState;
    /** 单位地址 */
    @ApiModelProperty(value = "单位地址", position = 6 )
    @Length(max=200, message = "单位地址不能大于200")
    private String unitAddress;

    /** 联系人姓名 */
    @ApiModelProperty(value = "联系人姓名", position = 8 )
    @Length(max=100, message = "联系人姓名不能大于100")
    private String linkName;
    /** 联系人电话 */
    @ApiModelProperty(value = "联系人电话", position = 9 )
    @Length(max=100, message = "联系人电话不能大于100")
    private String telephone;
    /** 联系人邮箱 */
    @ApiModelProperty(value = "联系人邮箱", position = 10 )
    @Length(max=100, message = "联系人邮箱不能大于100")
    private String email;
    /** 传真 */
    @ApiModelProperty(value = "传真", position = 1 )
    @Length(max=50, message = "传真不能大于50")
    private String fax;

    /** 组织机构代码/统一社会信用代码 */
    @ApiModelProperty(value = "组织机构代码/统一社会信用代码", position = 1 )
    @Length(max=50, message = "组织机构代码/统一社会信用代码不能大于50")
    private String organizationCode;
    /** 注册所在地 */
    @ApiModelProperty(value = "注册所在地", position = 1 )
    @Length(max=50, message = "注册所在地不能大于50")
    private String registeredAddress;
    /** 邮编 */
    @ApiModelProperty(value = "邮编", position = 7 )
    @Length(max=100, message = "邮编不能大于100")
    private String postCode;
    /** 法定代表人 */
    @ApiModelProperty(value = "法定代表人", position = 1 )
    @Length(max=50, message = "法定代表人不能大于50")
    private String legalPerson;
    /** 职工总数 */
    @ApiModelProperty(value = "职工总数", position = 1 )
    private Integer workforce;
    /** 其中专科以上人员 */
    @ApiModelProperty(value = "其中专科以上人员", position = 1 )
    private Integer specializedPersonnel;
    /** 研究开发人员 */
    @ApiModelProperty(value = "研究开发人员", position = 1 )
    private Integer researchPersonnel;

    /** 开户银行 */
    @ApiModelProperty(value = "开户银行", position = 1 )
    @Length(max=100, message = "开户银行不能大于100")
    private String depositBank;
    /** 银行账号 */
    @ApiModelProperty(value = "银行账号", position = 1 )
    @Length(max=50, message = "银行账号不能大于50")
    private String bankAccount;
    /** 开户银行地址 */
    @ApiModelProperty(value = "开户银行地址", position = 1 )
    @Length(max=100, message = "开户银行地址不能大于100")
    private String depositBankAddress;
    /** 银行联行号 */
    @ApiModelProperty(value = "银行联行号", position = 1 )
    @Length(max=50, message = "银行联行号不能大于50")
    private String interbankNumber;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 12 )
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 1 待审核，10 审核通过， 20 审核不通过 ，30 返回修改 */
    @ApiModelProperty(value = "审核结果", position = 6 )
    private Integer auditResult;
    /** 审核内容 */
    @ApiModelProperty(value = "审核内容", position = 5 )
    private String auditContent;
    /** 审核单位*/
    @ApiModelProperty(value = "审核单位", position = 28 )
    private String auditUnit;
    /** 审核人 */
    @ApiModelProperty(value = "审核人", position = 5 )
    private String auditPerson;
    /** 审核时间 */
    @ApiModelProperty(value = "审核时间", position = 7 )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date auditDate;


    /** 上级单位编码 */
    @ApiModelProperty(value = "上级单位编码", position = 17)
    private String upTreeCode;
}