package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 用户信息表DTO
 * 
 * @author lkl
 * @version 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "用户信息表DTO")
public class UserDTO extends BaseDTO {

    /** 用户Id */
    @ApiModelProperty(value = "用户Id", position = 2)
    //@NotNull(message = "用户Id不能为空")
    private String userId;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2)
    @NotNull(message = "密码不能为空")
    private String oldPassword;
    /** 密码 */
    @ApiModelProperty(value = "密码", position = 2)
    @NotNull(message = "密码不能为空")
    private String newPassword;
}