package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


@Data
public class ProjectKPIStatisticDTO extends BaseDTO {

    private Integer reportYear;
    private String projName;
    private String managerDept;
    private String appUnitName;
    private String projAttribute;
    private String projDeadline;
    private Date startDate;
    private Date endDate;
    /** 总预算数 */
    @ApiModelProperty(value = "总预算数", position = 3)
    private BigDecimal totalBudget;
    /** 申请专项经费(临床科技项目) */
    @ApiModelProperty(value = "申请专项经费", position = 4)
    private BigDecimal applyFunds;
    /** 自筹经费(临床科技项目) */
    @ApiModelProperty(value = "自筹经费", position = 5)
    private BigDecimal selfFunds;

    /** 用款总额 */
    private BigDecimal yearTotal;
    /** 省级财政资金 */
    private BigDecimal yearApply;
    /** 自筹资金 */
    private BigDecimal yearSelf;

    private String yearTarget;
    private String year1Goal;
    private String year2Goal;
    private String year3Goal;


    private Integer totalRowSpan; //总合并行数
    private Integer outTarget; //一级指标(产出指标)
    private Integer benefitTarget; //一级指标(效益指标)
    private Integer satisfactionDegree; //一级指标(满意度指标)
    private Integer quantityTarget; //二级指标(数量指标)
    private Integer qualityTarget; //二级指标(质量指标)
    private Integer validityTarget; //二级指标(时效指标)
    private Integer costTarget; //二级指标(成本指标)
    private Integer economicTarget; //二级指标(经济效益指标)
    private Integer socialTarget; //二级指标(社会效益指标)
    private Integer ecologicalTarget; //二级指标(生态效益指标)
    private Integer sustainableTarget; //二级指标(可持续影响指标)
    private Integer serviceTarget; //二级指标(服务对象满意度指标)
    private List<ComProjectKpitDTO> threeLevel;
    private List<ComProjectKpitDetailDTO> kpiList;
}
