package com.yiboshi.science.param.dto;

import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "人才分组分配表DTO")
public class ComTalentGroupAssignDTO extends BaseDTO {

    /** 人才分组Id */
    @ApiModelProperty(value = "人才分组Id", position = 1)
    @Length(max=36, message = "人才分组Id不能大于36")
    private String groupId;

    /** 专家Id */
    @ApiModelProperty(value = "专家Id", position = 2)
    @Length(max=36, message = "专家Id不能大于36")
    private String expertId;

    /** 专家姓名 */
    @ApiModelProperty(value = "专家姓名", position = 13)
    private String expertName;

    /** 专家证件号 */
    @ApiModelProperty(value = "专家证件号", position = 13)
    private String expertCertId;

    /** 专家职称Id */
    @ApiModelProperty(value = "专家职称Id", position = 13)
    private String title;

    /** 专家职称名称 */
    @ApiModelProperty(value = "专家职称名称", position = 13)
    private String titleName;

    /** 性别 */
    @ApiModelProperty(value = "性别", position = 13)
    private String sex;

    /** 工作单位 */
    @ApiModelProperty(value = "工作单位", position = 13)
    private String workUnit;

    /** 所属单位 */
    @ApiModelProperty(value = "所属单位", position = 13)
    private String unitName;

    /** 邮箱 */
    @ApiModelProperty(value = "邮箱", position = 13)
    private String email;

    /** 手机号 */
    @ApiModelProperty(value = "手机号", position = 13)
    private String mobile;

    /** 备注 */
    @ApiModelProperty(value = "备注", position = 3)
    @Length(max=500, message = "备注不能大于500")
    private String remark;

    /** 评审专业 */
    @ApiModelProperty(value = "评审专业", position = 13)
    private List<ComExpertSpecDTO> specList;

    /** 评审明细 */
    @ApiModelProperty(value = "评审明细", position = 14)
    private List<ComTalentAssignDTO> talentAssignList;
}
