package com.yiboshi.science.param.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yiboshi.science.base.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ApiModel(description = "专家批次表DTO")
public class ComExpertBatchDTO extends BaseDTO {
    /** 名称 */
    @ApiModelProperty(value = "名称", position = 2)
    @Length(max=200, message = "名称不能大于200")
    private String name;
    /** 年度 */
    @ApiModelProperty(value = "年度", position = 3)
    private Integer year;
    /** 批次 */
    @ApiModelProperty(value = "批次", position = 4 )
    private Integer batch;
    /** 备注 */
    @ApiModelProperty(value = "备注", position = 5)
    @Length(max=200, message = "备注不能大于200")
    private String remark;

    /** 专家组 */
    @ApiModelProperty(value = "专家组", position = 6)
    private List<ComExpertGroupDTO> expertGroup;
}
